//
// C++ Implementation: guiaffineregistration
//
// Description: 
//
//
// Author: Marta Kersten <mkersten@schubert>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "guiaffineregistration.h"

guiAffineRegistration::guiAffineRegistration()
{
	int xDim = 230; 
	int yDim = 200; 

	AffineRegWindow = new Fl_Window(xDim, yDim, "Rigid Registration");
	// ICPWindow->box(FL_PLASTIC_UP_BOX);
	AffineRegWindow->resizable(); 
	AffineRegWindow->begin();

	mainGroup = new Fl_Group(0, 30, (xDim-10), (yDim-10)); 
	mainGroup->resizable();

	int inputX = xDim - 100;
	paramGroup = new Fl_Group(inputX, 15, 150, 130); 

	transScale = new Fl_Value_Input(inputX, 15, 60, 20, "Translation Scale:"); 
	transScale->labelsize(10); 

	rotScale = new Fl_Value_Input(inputX, 40, 60, 20, "Rotation Scale:"); 
	rotScale->labelsize(10);
	
	numIter = new Fl_Value_Input(inputX, 65, 60, 20, "Number Iterations:"); 
	numIter->labelsize(10); 

	epsFunc = new Fl_Value_Input(inputX, 90, 60, 20, "Epsilon Function:");
	epsFunc->labelsize(10);
	
	paramGroup->end();

	// actions
	close = new Fl_Button( xDim-75, yDim-30, 70, 20, "Ok");
	close->box(FL_PLASTIC_UP_BOX);
	close->down_box(FL_PLASTIC_DOWN_BOX); 
	close->labelsize(10); 
	
	mainGroup->end();
	AffineRegWindow->end();
	
	transScale->callback(setTranslationScale_cb, this);
	rotScale->callback(setRotationScale_cb, this);
	numIter->callback(setNumIterations_cb, this);  
	epsFunc->callback(setEpsilonFunc_cb, this); 

	close->callback(close_cb, this); 

}

guiAffineRegistration::~guiAffineRegistration()
{
}

void guiAffineRegistration::Show()
{
	AffineRegWindow->show();
}


void guiAffineRegistration::close_cb(Fl_Widget *w, void *p)
{
	((guiAffineRegistration *) p)->AffineRegWindow->hide(); 
}

void guiAffineRegistration::setTranslationScale_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiAffineRegistration *) p)->SetTranslationScale(b->value());
}

void guiAffineRegistration::setRotationScale_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiAffineRegistration *) p)->SetRotationScale(b->value());
} 

void guiAffineRegistration::setNumIterations_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiAffineRegistration *) p)->SetNumIterations((long int)b->value());
}

void guiAffineRegistration::setEpsilonFunc_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiAffineRegistration *) p)->SetEpsilonFunction(b->value());
}


void guiAffineRegistration::SetRotationScale(double scale) { } 
void guiAffineRegistration::SetTranslationScale(double scale) { }
void guiAffineRegistration::SetNumIterations(long int number) { }
void guiAffineRegistration::SetEpsilonFunction(double epsilon) { }

void guiAffineRegistration::Register() { }
