//
// C++ Implementation: guilandmarkregistration
//
// Description: This is the pop-up window for changing the advanced options
// of the landmark registration algorithm. The functionality of the interface
// is implemented in guiLandmarkRegistrationImplementation.cpp
//
// Author:  <Marta Kersten>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "guilandmarkregistration.h"

guiLandmarkRegistration::guiLandmarkRegistration()
{
	int xDim = 230; 
	int yDim = 200; 

	LandRegWindow = new Fl_Window(xDim, yDim, "Landmark Registration");
	LandRegWindow->resizable(); 
	LandRegWindow->begin();

	mainGroup = new Fl_Group(0, 30, (xDim-10), (yDim-10)); 
	mainGroup->resizable();

	int inputX = xDim - 100;
	paramGroup = new Fl_Group(inputX, 15, 150, 130); 
	
	numIter = new Fl_Value_Input(inputX, 15, 60, 20, "Number Iterations:"); 
	numIter->labelsize(10); 

	epsFunc = new Fl_Value_Input(inputX, 40, 60, 20, "Epsilon Function:");
	epsFunc->labelsize(10);
	
	paramGroup->end();

	// actions
	close = new Fl_Button( xDim-75, yDim-30, 70, 20, "Ok");
	close->box(FL_PLASTIC_UP_BOX);
	close->down_box(FL_PLASTIC_DOWN_BOX); 
	close->labelsize(10); 
	
	mainGroup->end();
	LandRegWindow->end();

	numIter->callback(setNumIterations_cb, this);  
	epsFunc->callback(setEpsilonFunc_cb, this); 

	close->callback(close_cb, this); 

}

guiLandmarkRegistration::~guiLandmarkRegistration()
{
}

void guiLandmarkRegistration::Show()
{
	LandRegWindow->show();
}

void guiLandmarkRegistration::close_cb(Fl_Widget *w, void *p)
{
	((guiLandmarkRegistration *) p)->LandRegWindow->hide(); 
}

void guiLandmarkRegistration::setNumIterations_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiLandmarkRegistration *) p)->SetNumIterations((long int)b->value());
}

void guiLandmarkRegistration::setEpsilonFunc_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiLandmarkRegistration *) p)->SetEpsilonFunction(b->value());
}


void guiLandmarkRegistration::SetNumIterations(long int number) { }
void guiLandmarkRegistration::SetEpsilonFunction(double epsilon) { }

void guiLandmarkRegistration::Register() { }
void guiLandmarkRegistration::GetRegTransform() { }




