//
// C++ Implementation: guilandregimplementation
//
// Description: This class is the implementation of the advanced options 
// of the landmark registration algorithm. It allows for setting of the options
// of the landmark registration with is implemented in LandmarkRegistrator.cpp
//
// Author:  <Marta Kersten>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "guilandregimplementation.h"

guiLandRegImplementation::guiLandRegImplementation()
{
	landReg = new LandmarkRegistrator(); 
}


guiLandRegImplementation::~guiLandRegImplementation()
{
}

void guiLandRegImplementation::SetUp()
{
	//transScale->value(this->landReg->translationScale()); 
	//rotScale->value(this->landReg->rotationScale()); 
	numIter->value(this->landReg->numberOfIterations()); 
	epsFunc->value(this->landReg->epsilonFunction()); 
}

/*void guiLandRegImplementation::SetRotationScale(double scale)
{
	this->landReg->SetRotationScale(scale); 
}

void guiLandRegImplementation::SetTranslationScale(double scale)
{
	this->landReg->SetTranslationScale(scale); 
}*/

void guiLandRegImplementation::SetNumIterations(long int number)
{
	this->landReg->SetNumberOfIterations(number); 
}

void guiLandRegImplementation::SetEpsilonFunction(double epsilon)
{
	this->landReg->SetEpsilonFunction(epsilon); 
}

