//
// C++ Implementation: guimain
//
// Description: This class sets up the main GUI for the program. The functions are implemented in guiMainImplementation.cxx.
//
//
// Author:  Marta Kersten, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "guimain.h"
void guiMain::setDisplayMovingImage_cb(Fl_Widget* o, void*p)
{
	((guiMain *) p)->SetDisplayMovingImage(); 
}

void guiMain::setRegisteredView_cb(Fl_Menu_*o, void *p)
{
	((guiMain *) p)->SetView(REGISTERED); 
}

void guiMain::setFixedImageView_cb(Fl_Menu_*o, void *p)
{
	((guiMain *) p)->SetView(FIXED); 
}

void guiMain::setMovingImageView_cb(Fl_Menu_*o, void *p)
{
	((guiMain *) p)->SetView(MOVING); 
}

void guiMain::setUnregisteredView_cb(Fl_Menu_* o, void* p) {
  	((guiMain *) p)->SetView(UNREGISTERED);
}

void guiMain::setInitializedView_cb(Fl_Menu_*o, void *p)
{
	((guiMain *) p)->SetView(INITIALIZED); 
}

Fl_Menu_Item guiMain::menu_viewDisplayImageChoice[] = 
{		
	{"Fixed Image Only", 0, (Fl_Callback*)guiMain::setFixedImageView_cb, 0, 0, 0, 0, 10, 56},
	{"Moving Image Only", 0, (Fl_Callback*)setMovingImageView_cb, 0, 0, 0, 0, 10, 56},
	{"Unregistered Images", 0, (Fl_Callback*)setUnregisteredView_cb, 0, 0, 0, 0, 10, 56},
	{"Initialized Images", 0, (Fl_Callback*)setInitializedView_cb, 0, 1, 0, 0, 10, 56},
	{"Registered Images", 0, (Fl_Callback*)setRegisteredView_cb, 0, 1, 0, 0, 10, 56},
	{0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item* guiMain::fixedImageView = guiMain::menu_viewDisplayImageChoice + 0;
Fl_Menu_Item* guiMain::movingImageView = guiMain::menu_viewDisplayImageChoice + 1;
Fl_Menu_Item* guiMain::unregisteredView = guiMain::menu_viewDisplayImageChoice + 2;
Fl_Menu_Item* guiMain::initializedView = guiMain::menu_viewDisplayImageChoice + 3;
Fl_Menu_Item* guiMain::registeredView = guiMain::menu_viewDisplayImageChoice + 4;


void guiMain::setInitializationChoice_cb(Fl_Widget* o, void*p)
{
	((guiMain *) p)->SetInitializationChoice(); 
}

void guiMain::setInitializationNone_cb(Fl_Menu_*o, void *p)
{
	((guiMain *) p)->SetInitialization(NONE); 
}

void guiMain::setInitializationLandmark_cb(Fl_Menu_*o, void *p)
{
	((guiMain *) p)->SetInitialization(LANDMARK); 
}

void guiMain::setInitializationMoments_cb(Fl_Menu_*o, void *p)
{
	((guiMain *) p)->SetInitialization(MOMENTS); 
}

Fl_Menu_Item guiMain::menu_initializationChoice[] = 
{		
	{"None", 0, (Fl_Callback*)guiMain::setInitializationNone_cb, 0, 0, 0, 0, 10, 56},
	{"Landmarks", 0, (Fl_Callback*)setInitializationLandmark_cb, 0, 0, 0, 0, 10, 56},
	{"Moments", 0, (Fl_Callback*)setInitializationMoments_cb, 0, 0, 0, 0, 10, 56},
	{0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item* guiMain::noInitialization = guiMain::menu_initializationChoice + 0;
Fl_Menu_Item* guiMain::landmarkInitialization = guiMain::menu_initializationChoice + 1;
Fl_Menu_Item* guiMain::momentsInitialization = guiMain::menu_initializationChoice + 2;

void guiMain::setRegistrationChoice_cb(Fl_Widget* o, void*p)
{
	((guiMain *) p)->SetRegistrationChoice(); 
}

void guiMain::setRegistrationRigid_cb(Fl_Menu_*o, void *p)
{
	((guiMain *) p)->SetRegistrationAlgorithm(RIGID); 
}

void guiMain::setRegistrationAffine_cb(Fl_Menu_*o, void *p)
{
	((guiMain *) p)->SetRegistrationAlgorithm(AFFINE); 
}

void guiMain::setRegistrationICP_cb(Fl_Menu_*o, void *p)
{
	((guiMain *) p)->SetRegistrationAlgorithm(ICP); 
}

void guiMain::setRegistrationNone_cb(Fl_Menu_*o, void *p)
{
	((guiMain *) p)->SetRegistrationAlgorithm(NONE); 
}

Fl_Menu_Item guiMain::menu_registrationChoice[] = 
{		
	{"None", 0, (Fl_Callback*)guiMain::setRegistrationNone_cb, 0,  0, 0, 0, 10, 56,},
	{"Rigid", 0, (Fl_Callback*)guiMain::setRegistrationRigid_cb, 0,  0, 0, 0, 10, 56,},
	{"Affine", 0, (Fl_Callback*)guiMain::setRegistrationAffine_cb, 0,  FL_MENU_DIVIDER, 0, 0, 10, 56,},	
	{"ICP", 0, (Fl_Callback*)guiMain::setRegistrationICP_cb, 0, 0, 0, 0, 10, 56},
	{0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item* guiMain::noRegistration = guiMain::menu_registrationChoice + 0;
Fl_Menu_Item* guiMain::rigidRegistration = guiMain::menu_registrationChoice + 1;
Fl_Menu_Item* guiMain::affineRegistration = guiMain::menu_registrationChoice + 2;
Fl_Menu_Item* guiMain::ICPRegistration = guiMain::menu_registrationChoice + 3;

guiMain::guiMain()
{
	/* mainWindow GUI */
	int xDim = 1000; 
	int yDim = 680; 

	mainWindow = new Fl_Window(xDim, yDim, "MIR");
	mainWindow->size_range( xDim, yDim, 1280, 1040, 0, 0);
	mainWindow->visible();
	mainWindow->begin();

	mainGroup = new Fl_Group(0, 0, xDim, yDim);
	mainGroup->begin();

	/*--------------- FIXED image functions------------------*/
	fixedImageGroup = new Fl_Group(0, 0, 450, 420);	
	selectFixedImage = new Fl_Button (10, 15, 110, 20, "Select Fixed Image"); 
	selectFixedImage->labelsize(10);

	loadFixedLandmarks = new Fl_Button (10, 45, 110, 20, "Load Landmarks"); 
	loadFixedLandmarks->labelsize(10);

	saveFixedLandmarks = new Fl_Button (10, 75, 110, 20, "Save Landmarks"); 
	saveFixedLandmarks->labelsize(10);

	addFixedLandmark = new Fl_Button (10, 105, 110, 20, "Add Landmark"); 
	addFixedLandmark->labelsize(10);

	clearFixedLandmarks = new Fl_Button (10, 135, 110, 20, "Clear Landmarks"); 
	clearFixedLandmarks->labelsize(10);	

	fixedImageViewer = new SliceViewer < short >(154, 15, 275, 275, "fixed image"); 	
  	fixedImageViewer->box(FL_FLAT_BOX);
        fixedImageViewer->color((Fl_Color)42);
        fixedImageViewer->selection_color(FL_BACKGROUND_COLOR);
        fixedImageViewer->labeltype(FL_NORMAL_LABEL);
        fixedImageViewer->labelfont(0);
        fixedImageViewer->labelsize(14);
        fixedImageViewer->labelcolor(FL_BLACK);
        fixedImageViewer->align(FL_ALIGN_CENTER);
        fixedImageViewer->when(FL_WHEN_RELEASE);
        fixedImageViewer->deactivate();

	fixedSliceSlider = new Fl_Value_Slider(430, 15, 16, 275);
	fixedSliceSlider->box(FL_PLASTIC_DOWN_BOX); 
	fixedSliceSlider->color(260); 
	fixedSliceSlider->step(1);
	fixedSliceSlider->labelsize(8); 	
	
	fixedViewAxisGroup = new Fl_Group (210, 300, 210, 20, "View Axis");
	fixedViewAxisGroup->labelsize(10); 
	fixedViewAxisGroup->align(4); 
       	
	fixedViewAxisX = new Fl_Round_Button(240, 300, 25, 20, "X"); 
	fixedViewAxisX->down_box(FL_ROUND_DOWN_BOX); 
	fixedViewAxisX->labelsize(10); 
	fixedViewAxisX->user_data(0); 

	fixedViewAxisY = new Fl_Round_Button(285, 300, 25, 20, "Y"); 
	fixedViewAxisY->down_box(FL_ROUND_DOWN_BOX); 
	fixedViewAxisY->labelsize(10); 
	fixedViewAxisY->user_data(0); 

	fixedViewAxisZ = new Fl_Round_Button(325, 300, 25, 20, "Z"); 
	fixedViewAxisZ->down_box(FL_ROUND_DOWN_BOX); 
	fixedViewAxisZ->labelsize(10); 
	fixedViewAxisZ->user_data(0); 
	fixedViewAxisZ->value(0); 
	fixedViewAxisGroup->end();

	fixedImageGroup->resizable(fixedImageViewer);
	fixedImageGroup->end();	
		
	/*----------------- MOVING image functions -------------------*/
	movingImageGroup = new Fl_Group(0, 350, 450, 420);  
	selectMovingImage = new Fl_Button (10, 350, 110, 20, "Select Moving Image"); 
	selectMovingImage->labelsize(10); 

	loadMovingLandmarks = new Fl_Button (10, 380, 110, 20, "Load Landmarks"); 
	loadMovingLandmarks->labelsize(10);

	saveMovingLandmarks = new Fl_Button (10, 410, 110, 20, "Save Landmarks"); 
	saveMovingLandmarks->labelsize(10);

	addMovingLandmark = new Fl_Button (10, 440, 110, 20, "Add Landmark"); 
	addMovingLandmark->labelsize(10);

	clearMovingLandmarks = new Fl_Button (10, 470, 110, 20, "Clear Landmarks"); 
	clearMovingLandmarks->labelsize(10);
	
	movingImageGroup->begin();
	movingImageViewer = new SliceViewer < short > (154, 350, 275, 275, "moving image"); 
	movingImageViewer->box(FL_FLAT_BOX);
        movingImageViewer->color((Fl_Color)42);
        movingImageViewer->selection_color(FL_BACKGROUND_COLOR);
        movingImageViewer->labeltype(FL_NORMAL_LABEL);
        movingImageViewer->labelfont(0);
        movingImageViewer->labelsize(14);
        movingImageViewer->labelcolor(FL_BLACK);
        movingImageViewer->align(FL_ALIGN_CENTER);
        movingImageViewer->when(FL_WHEN_RELEASE);
        movingImageViewer->deactivate();

	movingSliceSlider = new Fl_Value_Slider(430, 350, 16, 275); 
	movingSliceSlider->box(FL_PLASTIC_DOWN_BOX); 
	movingSliceSlider->color(260); 
	movingSliceSlider->step(1);
	movingSliceSlider->when(FL_WHEN_CHANGED);
	movingSliceSlider->labelsize(8); ; 

	movingViewAxisGroup = new Fl_Group (210, yDim-50, 210, 20, "View Axis");
	movingViewAxisGroup->labelsize(10); 
	movingViewAxisGroup->align(4);

	movingViewAxisX = new Fl_Round_Button(240, yDim-50, 25, 20, "X"); 
	movingViewAxisX->down_box(FL_ROUND_DOWN_BOX); 
	movingViewAxisX->labelsize(10); 
	movingViewAxisX->user_data(0); 

	movingViewAxisY = new Fl_Round_Button(285, yDim-50, 25, 20, "Y"); 
	movingViewAxisY->down_box(FL_ROUND_DOWN_BOX); 
	movingViewAxisY->labelsize(10); 
	movingViewAxisY->user_data(0); 

	movingViewAxisZ = new Fl_Round_Button(325, yDim-50, 25, 20, "Z"); 
	movingViewAxisZ->down_box(FL_ROUND_DOWN_BOX); 
	movingViewAxisZ->labelsize(10); 
	movingViewAxisZ->user_data(0); 
	movingViewAxisZ->value(0); 
	movingViewAxisGroup->end();

	movingImageGroup->resizable(movingImageViewer);
	movingImageGroup->end();
	
	/* ------------------------------------------------------*/
	

	/* --------------RESULT VIEWER + FUNCTIONS GROUP -------------------*/ 
	resultImageGroup = new Fl_Group(525, 10, 500, 450);
	resultImageGroup->begin(); 

	resultImageViewer = new GLTwoImageSliceView< short, unsigned char >(525, 15, 450, 400, "result");
        resultImageViewer->box(FL_FLAT_BOX);
        resultImageViewer->color((Fl_Color)42);
        resultImageViewer->selection_color(FL_BACKGROUND_COLOR);
        resultImageViewer->labeltype(FL_NORMAL_LABEL);
        resultImageViewer->labelfont(0);
        resultImageViewer->labelsize(14);
        resultImageViewer->labelcolor(FL_BLACK);
        resultImageViewer->align(FL_ALIGN_CENTER);
        resultImageViewer->when(FL_WHEN_RELEASE);
        resultImageViewer->deactivate();

	resultSliceSlider = new Fl_Value_Slider(980, 15, 16, 400);
	resultSliceSlider->box(FL_PLASTIC_DOWN_BOX); 
	resultSliceSlider->color(260); 
	resultSliceSlider->step(1);

	displayImageChoice = new Fl_Choice(xDim-180, yDim-260, 158, 15, "Currently Displayed Image(s):");
        displayImageChoice->box(FL_PLASTIC_UP_BOX);
        displayImageChoice->down_box(FL_BORDER_BOX);
        displayImageChoice->color(FL_WHITE);
        displayImageChoice->selection_color(FL_WHITE);
        displayImageChoice->labelsize(10);
        displayImageChoice->textsize(10);
	displayImageChoice->callback(setDisplayMovingImage_cb, this);
        displayImageChoice->when(FL_WHEN_CHANGED);
        displayImageChoice->menu(menu_viewDisplayImageChoice);

	for (Fl_Menu_Item *i = menu_viewDisplayImageChoice; i != NULL && i->label() != NULL; i = i->next())
		i->user_data(this);
	
	resultImageGroup->resizable(resultImageViewer);
	resultImageGroup->end();
	
	/* -----------------REGISTER functions group  -------------------*/
	registerGroup = new Fl_Group(525, 460, 450, 185, "");
	registerGroup->labelsize(12); 
	registerGroup->box(FL_ENGRAVED_FRAME);

	int yOutputBox = 500;	
	
	/* input group (initialization/registration method) */
	inputGroup = new Fl_Group(480, yOutputBox-20, 300, 220); 
	inputGroup->label("REGISTRATION:"); 
	inputGroup->align(FL_ALIGN_LEFT);
	inputGroup->align(FL_ALIGN_TOP);
	inputGroup->labelsize(10);

	initializationChoice = new Fl_Choice(635, yOutputBox-10, 100, 15, "Initialization Method:");
     //   initializationChoice->box(FL_PLASTIC_UP_BOX);
        initializationChoice->down_box(FL_BORDER_BOX);
        initializationChoice->color(FL_WHITE);
        initializationChoice->selection_color(FL_WHITE);
        initializationChoice->labelsize(10);
        initializationChoice->textsize(10);
	initializationChoice->callback(setInitializationChoice_cb, this);
        initializationChoice->when(FL_WHEN_CHANGED);
        initializationChoice->menu(menu_initializationChoice);

	for (Fl_Menu_Item *i = menu_initializationChoice; i != NULL && i->label() != NULL; i = i->next())
		i->user_data(this);

	registrationChoice = new Fl_Choice(635, yOutputBox+50, 100, 15, "Registration Method:");
        registrationChoice->box(FL_PLASTIC_UP_BOX);
        registrationChoice->down_box(FL_BORDER_BOX);
        registrationChoice->color(FL_WHITE);
        registrationChoice->selection_color(FL_WHITE);
        registrationChoice->labelsize(10);
        registrationChoice->textsize(10);
	registrationChoice->callback(setRegistrationChoice_cb, this);
        registrationChoice->when(FL_WHEN_CHANGED);
        registrationChoice->menu(menu_registrationChoice);

	for (Fl_Menu_Item *i = menu_registrationChoice; i != NULL && i->label() != NULL; i = i->next())
		i->user_data(this);

	// actions
	advancedRegOptions = new Fl_Button( 635, yOutputBox+70, 100, 20, "Advanced Options");
	advancedRegOptions->labelsize(10); 
	
	advancedInitOptions = new Fl_Button( 635, yOutputBox+10, 100, 20, "Advanced Options");
	advancedInitOptions->labelsize(10); 
	
	reg = new Fl_Button( 535, yOutputBox+110, 70, 20, "Register");
	reg->color(62); 
	reg->selection_color(63);
	reg->labelsize(10); 

	inputGroup->end(); 
	/* end input group */

	/* output group (rotation/translation...)*/
	outputGroup = new Fl_Group(780, yOutputBox-20, 220, 100);
	outputGroup->label("OUTPUT:"); 
	outputGroup->align(FL_ALIGN_LEFT);
	outputGroup->align(FL_ALIGN_TOP);
	outputGroup->labelsize(10);
	
	transOutputGroup = new Fl_Group(810, yOutputBox, 75, 80, "Translation");
	transOutputGroup->labelsize(10); 
	transOutputGroup->box(FL_ENGRAVED_FRAME);
	
	xTrans = new Fl_Output(830, yOutputBox+10, 50, 20, "X"); 
	yTrans = new Fl_Output(830, yOutputBox+30, 50, 20, "Y"); 
	zTrans = new Fl_Output(830, yOutputBox+50, 50, 20, "Z"); 

	rotOutputGroup = new Fl_Group( 890, yOutputBox, 75, 80, "Rotation");
	rotOutputGroup->labelsize(10); 
	rotOutputGroup->box(FL_ENGRAVED_FRAME);
		
	xRot = new Fl_Output(910, yOutputBox+10, 50, 20, "X"); 
	yRot = new Fl_Output(910, yOutputBox+30, 50, 20, "Y"); 
	zRot = new Fl_Output(910, yOutputBox+50, 50, 20, "Z"); 

	outputGroup->end(); 
	/* end output group*/

	statusDisplay = new Fl_Output(xDim-310, yDim-25, 285, 20, "Status");
        statusDisplay->labelsize(10);
        statusDisplay->textsize(10);
	statusDisplay->value("Ready");

	mainGroup->resizable();
	mainGroup->end();

	mainWindow->resizable(mainGroup); 
	mainWindow->end();

	selectFixedImage->callback(selectFixedImageFile_cb, this); 	selectMovingImage->callback(selectMovingImageFile_cb, this);

	loadFixedLandmarks->callback(loadFixedLandmarks_cb, this); 
	loadMovingLandmarks->callback(loadMovingLandmarks_cb, this); 

	saveFixedLandmarks->callback(saveFixedLandmarks_cb, this); 
	saveMovingLandmarks->callback(saveMovingLandmarks_cb, this); 

	clearFixedLandmarks->callback(clearFixedLandmarks_cb, this); 
	clearMovingLandmarks->callback(clearMovingLandmarks_cb, this); 

	addFixedLandmark->callback(addLandmark_cb, this); 
	addMovingLandmark->callback(addLandmark_cb, this); 

	fixedSliceSlider->callback(updateFixedSliceNumber_cb, this);
	movingSliceSlider->callback(updateMovingSliceNumber_cb, this);
	resultSliceSlider->callback(updateResultSliceNumber_cb, this);

	fixedViewAxisX->callback(changeFixedViewAxisX_cb, this); 
	fixedViewAxisY->callback(changeFixedViewAxisY_cb, this);
	fixedViewAxisZ->callback(changeFixedViewAxisZ_cb, this);

	movingViewAxisX->callback(changeMovingViewAxisX_cb, this); 
	movingViewAxisY->callback(changeMovingViewAxisY_cb, this);
	movingViewAxisZ->callback(changeMovingViewAxisZ_cb, this);

/*	icp->callback(setistrationAlgorithmICP_cb, this); 
	landmark->callback(setRegistrationAlgorithmLAND_cb, this); 
	mutualInfo->callback(setRegistrationAlgorithmMUTUALINFO_cb, this); 
	moments->callback(setRegistrationAlgorithmMOMENTS_cb, this); */
	
	advancedRegOptions->callback(showAdvancedRegOptions_cb, this); 
	advancedInitOptions->callback(showAdvancedInitOptions_cb, this); 
	reg->callback(register_cb, this); 
	
	mainWindow->show();
	
	fixedImageViewer->update();
	movingImageViewer->update();
	resultImageViewer->update(); 
	
	fixedImageViewer->redraw();
	movingImageViewer->redraw(); 
	resultImageViewer->redraw(); 
	
	fixedImageViewer->deactivate();
	movingImageViewer->deactivate(); 
	resultImageViewer->deactivate(); 

	fixedImageViewer->show();
	movingImageViewer->show();
	resultImageViewer->show(); 

	numFixedLandmarks = 0; 
	numMovingLandmarks = 0; 
}


guiMain::~guiMain()
{
}

void guiMain::selectFixedImageFile_cb(Fl_Widget* o, void*p)
{
	((guiMain *) p)->SelectImage(FIXED); 
}

void guiMain::selectMovingImageFile_cb(Fl_Widget* o, void*p)
{
	((guiMain *) p)->SelectImage(MOVING); 
}

void guiMain::updateMovingSliceNumber_cb(Fl_Widget* o, void*p)
{
	((guiMain *) p)->UpdateMovingSliceView(); 
}


void guiMain::updateFixedSliceNumber_cb(Fl_Widget* o, void*p)
{
	((guiMain *) p)->UpdateFixedSliceView(); 
}

void guiMain::updateResultSliceNumber_cb(Fl_Widget* o, void*p)
{
	((guiMain *) p)->UpdateResultSliceView(); 
}

void guiMain::changeFixedViewAxisX_cb(Fl_Widget*o, void *p)
{
	((guiMain *) p)->SetFixedViewAxis(0); 
}

void guiMain::changeFixedViewAxisY_cb(Fl_Widget*o, void *p)
{
	((guiMain *) p)->SetFixedViewAxis(1); 
}

void guiMain::changeFixedViewAxisZ_cb(Fl_Widget*o, void *p)
{
	((guiMain *) p)->SetFixedViewAxis(2); 
}

void guiMain::changeMovingViewAxisX_cb(Fl_Widget*o, void *p)
{
	((guiMain *) p)->SetMovingViewAxis(0); 
}

void guiMain::changeMovingViewAxisY_cb(Fl_Widget*o, void *p)
{
	((guiMain *) p)->SetMovingViewAxis(1); 
}

void guiMain::changeMovingViewAxisZ_cb(Fl_Widget*o, void *p)
{
	((guiMain *) p)->SetMovingViewAxis(2); 
}

void guiMain::addLandmark_cb(Fl_Widget*o, void *p)
{	
	((guiMain *) p)->AddLandmark(o->parent()); 
}

/*void guiMain::setRegistrationAlgorithmICP_cb(Fl_Widget*o, void *p)
{ 
	((guiMain *)p)->SetRegistrationAlgorithm(ICP); 
}

void guiMain::setRegistrationAlgorithmLAND_cb(Fl_Widget*o, void *p)
{ 
	((guiMain *) p)->SetRegistrationAlgorithm(LANDMARK); 
}

void guiMain::setRegistrationAlgorithmMUTUALINFO_cb(Fl_Widget*o, void *p)
{ 
	((guiMain *) p)->SetRegistrationAlgorithm(MUTUALINFO); 
}

void guiMain::setRegistrationAlgorithmMOMENTS_cb(Fl_Widget*o, void *p)
{ 
	((guiMain *) p)->SetRegistrationAlgorithm(MOMENTS); 
}*/

void guiMain::loadFixedLandmarks_cb(Fl_Widget *o, void *p)
{
	((guiMain *) p)->LoadLandmarks(FIXED);
}

void guiMain::loadMovingLandmarks_cb(Fl_Widget *o, void *p)
{
	((guiMain *) p)->LoadLandmarks(MOVING); 
}

void guiMain::clearFixedLandmarks_cb(Fl_Widget *o, void *p)
{
	((guiMain *) p)->ClearLandmarks(FIXED);
}

void guiMain::clearMovingLandmarks_cb(Fl_Widget *o, void *p)
{
	((guiMain *) p)->ClearLandmarks(MOVING); 
}

void guiMain::saveFixedLandmarks_cb(Fl_Widget *o, void *p)
{
	((guiMain *) p)->SaveLandmarks(FIXED);
}

void guiMain::saveMovingLandmarks_cb(Fl_Widget *o, void *p)
{
	((guiMain *) p)->SaveLandmarks(MOVING); 
}

void guiMain::register_cb(Fl_Widget *o, void*p) 
{
	((guiMain *) p)->Initialize(); 
}

void guiMain::showAdvancedRegOptions_cb(Fl_Widget *o, void*p) 
{
	((guiMain *) p)->ShowAdvancedRegOptions(); 
}

void guiMain::showAdvancedInitOptions_cb(Fl_Widget *o, void*p) 
{
	((guiMain *) p)->ShowAdvancedInitOptions(); 
}

void guiMain::SelectImage(int isFixedImage) { }
void guiMain::UpdateMovingSliceView() { }
void guiMain::UpdateFixedSliceView() { }
void guiMain::UpdateResultSliceView() { }
void guiMain::SetMovingViewAxis(unsigned int axis) { }
void guiMain::SetFixedViewAxis(unsigned int axis) { }
void guiMain::SetView(unsigned int view) { }
void guiMain::SetInitialization(unsigned int initialization) { }
void guiMain::AddLandmark(Fl_Widget *w) { }
void guiMain::SetRegistrationAlgorithm(unsigned int algo) { } 
void guiMain::LoadLandmarks(unsigned int isFixed) { }
void guiMain::SaveLandmarks(unsigned int isFixed) { }
void guiMain::ClearLandmarks(unsigned int isFixed) { }
void guiMain::ShowAdvancedRegOptions() { }
void guiMain::ShowAdvancedInitOptions() { }
void guiMain::Register() { } 
void guiMain::Initialize() { }
void guiMain::SetDisplayMovingImage(){ }
void guiMain::SetInitializationChoice() { }
void guiMain::SetRegistrationChoice() { }
