//
// C++ Implementation: landmarkregistrator
//
// Description: 
//
//
// Author:  <>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "landmarkregistrator.h"
#include <itkSpatialObjectPoint.h> 
#include "errorwindow.h"

LandmarkRegistrator::LandmarkRegistrator()
{
	my_fixedImage = 0; 
	my_movingImage = 0; 
	my_initializedMovingImage = 0;

	my_center.Fill(0);
	
	SetNumberOfIterations(2000); 
	
	my_transform = TransformType::New();
	my_generator = GeneratorType::New();
	my_landmarkMetric = LandmarkMetricType::New(); 
	my_landmarkOptimizer = OptimizerType::New(); 	
	my_resampleFilter = ResampleFilterType::New();

	my_fixedLandmarkSet  = LandmarkSetType::New(); 
	my_movingLandmarkSet = LandmarkSetType::New();

	// set optimizer parameters to defaults	
	my_transform->SetIdentity();
	my_initialTransformParameters = my_transform->GetParameters();

	my_optimizerScales.set_size(6);
	my_optimizerScales[0] = 200; // rotation
	my_optimizerScales[1] = 200;
	my_optimizerScales[2] = 200;
	my_optimizerScales[3] = 1;   // offset
	my_optimizerScales[4] = 1;
	my_optimizerScales[5] = 1;
}


LandmarkRegistrator::~LandmarkRegistrator()
{
}


bool LandmarkRegistrator::InitializeRegistration()
{ 
 /*	for (int i = 0; i < my_fixedLandmarkSet->GetPoints().size(); i++)
	{
		 std::cout<< "DEBUG: Fixed landmarks" << my_fixedLandmarkSet->GetPoint(i)->GetPosition() << std::endl; 
	}

	for (int i = 0; i < my_movingLandmarkSet->GetPoints().size(); i++)
	{
		 std::cout<< "DEBUG: Moving landmark" << my_movingLandmarkSet->GetPoint(i)->GetPosition() << std::endl; 
	}*/

	my_generator->Initialize(1289);
	
	if( my_fixedLandmarkSet->GetNumberOfPoints() 
	!= my_movingLandmarkSet->GetNumberOfPoints())
	{
		char *errorString = "Landmark sets do not have the same number of elements";
		ErrorWindow *error = new ErrorWindow(errorString);
		error->Show(); 
		return (false);
	}
	
	itk::Point<double, 3> fixedCenter;
	fixedCenter.Fill(0);
	itk::Point<double, 3> movingCenter;
	movingCenter.Fill(0);
	for( unsigned int i=0; i<my_movingLandmarkSet->GetNumberOfPoints(); i++)
	{
		for( unsigned int j=0; j<3; j++)
		{
			fixedCenter[j] += my_fixedLandmarkSet->GetPoint(i)->GetPosition()[j];
			movingCenter[j] += my_movingLandmarkSet->GetPoint(i)->GetPosition()[j];
		}
	}
	for( unsigned int j=0; j<3; j++)
	{
		fixedCenter[j] /= my_fixedLandmarkSet->GetNumberOfPoints();
		movingCenter[j] /= my_movingLandmarkSet->GetNumberOfPoints();
	}
	
	my_initialTransformParameters[3] = fixedCenter[0]-movingCenter[0];
	my_initialTransformParameters[4] = fixedCenter[1]-movingCenter[1];
	my_initialTransformParameters[5] = fixedCenter[2]-movingCenter[2];
	
	vnl_vector<double> v1(3);
	vnl_vector<double> v2(3);
	vnl_vector<double> vTemp(3);
	vnl_matrix<double> m(3,3);
	vnl_matrix<double> mTemp(3,3);
	m.set_identity();
	
	itk::Vector<double, 3> vct;
	itk::Versor<double> vsr;
	itk::Versor<double> vsrTemp;
	itk::Matrix<double, 3, 3> mat;
	
	mat = m;
	vsr.Set(mat);
	double weight = 0.5;
	for( int count = 0; count < 5; count++)
	{
		for( unsigned int i=0; i<my_movingLandmarkSet->GetNumberOfPoints(); i++)
		{
			v1 = (my_movingLandmarkSet->GetPoint(i)->GetPosition().GetVnlVector()
				- movingCenter.GetVnlVector());
			v1.normalize();
			
			v2 = (my_fixedLandmarkSet->GetPoint(i)->GetPosition().GetVnlVector()
				- fixedCenter.GetVnlVector());
			v2.normalize();
			
			vTemp = m * v1;
			vTemp.normalize();
			mat = outer_product(v2, vTemp);
			vsrTemp.Set(mat);
			
			vct[0] = vsr.GetX() + weight * vsrTemp.GetX();
			vct[1] = vsr.GetY() + weight * vsrTemp.GetY();
			vct[2] = vsr.GetZ() + weight * vsrTemp.GetZ();
			if(vct.GetNorm() > 1) 
				{
				vct.Normalize();
				}
			std::cout << "vct = " << vct << std::endl;
			std::cout << "vct.norm = " << vct.GetNorm() << std::endl;
			vsr.Set(vct);
			std::cout << "   done" << std::endl;
			
			m = vsr.GetMatrix().GetVnlMatrix();
		}
		weight *= 0.75;
	}
	
	std::cout << "Landmark quality :" << std::endl;
	for( unsigned int i=0; i<my_movingLandmarkSet->GetNumberOfPoints(); i++)
	{
		v1 = (my_movingLandmarkSet->GetPoint(i)->GetPosition().GetVnlVector()
			- movingCenter.GetVnlVector());
		v1.normalize();
		
		v2 = (my_fixedLandmarkSet->GetPoint(i)->GetPosition().GetVnlVector()
			- fixedCenter.GetVnlVector());
		v2.normalize();
		
		vTemp = vsr.Transform(v1);
		vTemp.normalize();
		std::cout << "Landmark " << i << " : fit as T(m)*f = "
			<< dot_product(vTemp, v2) << std::endl;
	}
	
	my_initialTransformParameters[0] = vsr.GetRight()[0];
	my_initialTransformParameters[1] = vsr.GetRight()[1];
	my_initialTransformParameters[2] = vsr.GetRight()[2];
	
	std::cout << "LandmarkRegistrator: InitialParameters = " << std::endl
		<< my_initialTransformParameters << std::endl;
	try
	{
		my_landmarkMetric->SetFixedPointSet(my_fixedLandmarkSet);
		my_landmarkMetric->SetMovingPointSet(my_movingLandmarkSet);
		my_landmarkMetric->SetCenter(movingCenter);
		my_landmarkOptimizer->SetInitialPosition(my_initialTransformParameters);
		my_landmarkOptimizer->SetScales(my_optimizerScales);
		my_landmarkOptimizer->SetCostFunction(my_landmarkMetric);
		my_landmarkOptimizer->SetNormalVariateGenerator(my_generator);
		my_landmarkOptimizer->SetMaximumIteration(my_numberOfIterations);
		my_landmarkOptimizer->Initialize(4.0, 1.1, 0.9); // Initial search radius
		my_landmarkOptimizer->SetEpsilon(0.00000001);
		my_landmarkOptimizer->StartOptimization();
	}
	catch( itk::ExceptionObject &e )
	{
		char *errorString = (char*)&e;
		ErrorWindow *error = new ErrorWindow(errorString);
		error->Show();
		return(false);
	}
	catch( ... )
	{
		char *errorString = "Unknown exception caught in LandmarkRegistrator:";
		ErrorWindow *error = new ErrorWindow(errorString);
		error->Show(); 
		return(false);
	}
	
	my_transform = TransformType::New();
	my_transform->SetParameters(my_landmarkOptimizer->GetCurrentPosition());
	my_transform->SetCenter(movingCenter);

/*	my_resampleFilter->SetInput(my_movingImage); 
	my_resampleFilter->SetOutputOrigin(my_fixedImage->GetOrigin()); 
	my_resampleFilter->SetOutputSpacing(my_fixedImage->GetSpacing()); 
	my_resampleFilter->SetSize(my_fixedImage->GetLargestPossibleRegion().GetSize());
   	AffineTransformType::Pointer inverse = AffineTransformType::New();
	my_transform->GetInverse(inverse); 
  	my_resampleFilter->SetTransform(inverse);
  	my_resampleFilter->Update();

	my_center = movingCenter;
	my_initializedMovingImage = my_resampleFilter->GetOutput();*/
	return(true); 

}	


double LandmarkRegistrator::epsilonFunction() const
{
  return my_epsilonFunction;
}


void LandmarkRegistrator::SetNumberOfIterations(unsigned int iters)
{
	my_numberOfIterations = iters;
}


void LandmarkRegistrator::SetEpsilonFunction(double epsilon)
{
	my_epsilonFunction = epsilon; 
} 

unsigned long LandmarkRegistrator::numberOfIterations() const
{
  	return my_numberOfIterations;
}
