//
// C++ Implementation: miregistration
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "miregistration.h"
class CommandIterationUpdate : public itk::Command
{
public:
  typedef  CommandIterationUpdate   Self;
  typedef  itk::Command             Superclass;
  typedef itk::SmartPointer<Self>  Pointer;
  itkNewMacro( Self );
protected:
  CommandIterationUpdate() {};
public:
  typedef itk::RegularStepGradientDescentOptimizer     OptimizerType;
  typedef   const OptimizerType   *    OptimizerPointer;

  void Execute(itk::Object *caller, const itk::EventObject & event)
    {
      Execute( (const itk::Object *)caller, event);
    }

  void Execute(const itk::Object * object, const itk::EventObject & event)
    {
      OptimizerPointer optimizer =
        dynamic_cast< OptimizerPointer >( object );
      if( ! itk::IterationEvent().CheckEvent( &event ) )
        {
        return;
        }
      std::cout << optimizer->GetCurrentIteration() << "   ";
      std::cout << optimizer->GetValue() << "   ";
      std::cout << optimizer->GetCurrentPosition() << std::endl;
    }
};

MIRegistration::MIRegistration()
{
	my_fixedImage = 0; 
	my_movingImage = 0;
	
	my_transform = TransformType::New(); 
	my_optimizer = OptimizerType::New(); 
	my_interpolator = InterpolatorType::New(); 
	my_registrator = RegistrationType::New(); 
	my_metric = MetricType::New(); 
 	
	my_initializer = TransformInitializerType::New(); 

	my_transform->SetIdentity();
	my_initialTransformParameters = my_transform->GetParameters();

	my_numberOfBins = 64; 
	my_numberOfSamples = 10000; 
	my_numberOfIterations = 1000; 
	my_relaxationFactor = 0.8; 

	my_maxStepLength = 0.02; 
	my_minStepLength = 0.001;
}


MIRegistration::~MIRegistration()
{
}

bool MIRegistration::Register()
{
	my_registrator->SetMetric(my_metric); 
	my_registrator->SetOptimizer(my_optimizer); 
	my_registrator->SetInterpolator(my_interpolator); 
	my_registrator->SetTransform(my_transform); 

	my_metric->SetNumberOfHistogramBins(my_numberOfBins); 
	my_metric->SetNumberOfSpatialSamples(my_numberOfSamples); 

	my_registrator->SetFixedImage(my_fixedImage); 
	my_registrator->SetMovingImage(my_fixedImage); 

	my_registrator->SetFixedImageRegion(my_fixedImage->GetBufferedRegion());
	
	my_initializer->SetTransform(my_transform); 
	my_initializer->SetFixedImage(my_fixedImage); 
	my_initializer->SetMovingImage(my_movingImage); 
	my_initializer->MomentsOn(); 
	my_initializer->InitializeTransform(); 

	my_axis[0] = 0.0;
	my_axis[1] = 0.0;
	my_axis[2] = 1.0;
	
	const double angle = 0;
	my_rotation.Set(  my_axis, angle  );
	
	my_transform->SetRotation( my_rotation );
//	my_transform->SetTranslation(my_fixedImage->GetOrigin() - my_movingImage->GetOrigin()); 
	
	my_registrator->SetInitialTransformParameters( my_transform->GetParameters() );
	
	ScalesType my_optimizerScales( my_transform->GetNumberOfParameters() );
	const double translationScale = 1.0 / 1000.0;

	my_optimizerScales[0] = 1.0;
	my_optimizerScales[1] = 1.0;
	my_optimizerScales[2] = 1.0;
	my_optimizerScales[3] = translationScale;
	my_optimizerScales[4] = translationScale;
	my_optimizerScales[5] = translationScale;
	
	my_optimizer->SetScales( my_optimizerScales ); 
	my_optimizer->SetInitialPosition(my_transform->GetParameters());
	my_optimizer->MinimizeOn(); 
	my_optimizer->SetMaximumStepLength(my_maxStepLength); 
	my_optimizer->SetMinimumStepLength(my_minStepLength);
	my_optimizer->SetNumberOfIterations(my_numberOfIterations);
	my_optimizer->SetRelaxationFactor(my_relaxationFactor); 

  //	CommandIterationUpdate::Pointer observer = CommandIterationUpdate::New();
  //	my_optimizer->AddObserver( itk::IterationEvent(), observer );

	try
	{	
		my_registrator->StartRegistration(); 
	}
	catch (itk::ExceptionObject &err)
	{
		char *errorString = (char*)&err;
		ErrorWindow *error = new ErrorWindow(errorString);
		error->Show();
		return(false);
	}
	catch( ... )
	{
		char *errorString = "Unknown exception caught in Mutual Information Registrator:";
		ErrorWindow *error = new ErrorWindow(errorString);
		error->Show(); 
		return(false);
	}
	my_transform->SetParameters( my_registrator->GetLastTransformParameters() );
	return true;
}

void MIRegistration::SetNumberOfBins(unsigned int bins)
{
	my_numberOfBins = bins; 
}

void MIRegistration::SetNumberOfSamples(unsigned int samples)
{
	my_numberOfSamples = samples; 
}

void MIRegistration::SetMaxStepLength(double maxLength)
{
	my_maxStepLength = maxLength; 
}

void MIRegistration::SetMinStepLength(double minLength)
{
	my_minStepLength = minLength; 
}

void MIRegistration::SetNumberOfIterations(unsigned int  numIter)
{
	my_numberOfIterations = numIter; 
}

void MIRegistration::SetRelaxationFactor(double factor)
{
	my_relaxationFactor = factor; 
}

double MIRegistration::minStep()
{
	return my_minStepLength; 
}

double MIRegistration::maxStep()
{
	return my_maxStepLength; 
}

double MIRegistration::relaxationFactor()
{
	return my_relaxationFactor; 
}
unsigned int MIRegistration::numberOfIterations()
{
	return my_numberOfIterations; 
}

unsigned int MIRegistration::numberOfBins()
{
	return my_numberOfBins; 
}

unsigned int MIRegistration::numberOfSamples()
{
	return my_numberOfSamples; 
}
