//
// C++ Implementation: rigidregistration
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "rigidregistration.h"

#include "itkCommand.h"
class CommandIterationUpdate : public itk::Command
{
public:
  typedef  CommandIterationUpdate   Self;
  typedef  itk::Command             Superclass;
  typedef itk::SmartPointer<Self>  Pointer;
  itkNewMacro( Self );
protected:
  CommandIterationUpdate() {};
public:
  typedef itk::OnePlusOneEvolutionaryOptimizer    OptimizerType;
  typedef   const OptimizerType   *    OptimizerPointer;

  void Execute(itk::Object *caller, const itk::EventObject & event)
    {
      Execute( (const itk::Object *)caller, event);
    }

  void Execute(const itk::Object * object, const itk::EventObject & event)
    {
      OptimizerPointer optimizer =
        dynamic_cast< OptimizerPointer >( object );
      if( ! itk::IterationEvent().CheckEvent( &event ) )
        {
        return;
        }
      std::cout << optimizer->GetCurrentIteration() << "   ";
      std::cout << optimizer->GetValue() << "   ";
      std::cout << optimizer->GetCurrentPosition() << std::endl;
    }
};


RigidRegistration::RigidRegistration()
{
	my_fixedImage = 0; 
	my_movingImage = 0; 

	// set registration parameters to defaults
	SetNumberOfIterations(500);
	SetNumberOfSamples(20000); 
	SetEpsilonFunction(1e-10); 
	
	my_metric = MetricType::New(); 
	my_transform = TransformType::New();
	my_optimizer = OptimizerType::New(); 
	my_generator = GeneratorType::New();
	my_registration = RegistrationType::New(); 	
	my_resampleFilter = ResampleFilterType::New();
	my_finalTransform = RigidTransformType::New(); 
	my_interpolator = InterpolatorType::New();

	my_transform->SetIdentity();
	my_initialTransformParameters = my_transform->GetParameters();
	
	my_optimizerScales.set_size(6);
	my_optimizerScales[0] = 200; // rotation
	my_optimizerScales[1] = 200;
	my_optimizerScales[2] = 200;
	my_optimizerScales[3] = 1;   // offset
	my_optimizerScales[4] = 1;
	my_optimizerScales[5] = 1;
}

RigidRegistration::~RigidRegistration()
{
}

bool RigidRegistration::Register()
{	

	// ITK transforms the fixed image into the moving image
	my_registration->SetMovingImage(my_fixedImage) ;     
	my_registration->SetFixedImage(my_movingImage);  
	
	my_registration->SetFixedImageRegion(my_movingImage->GetBufferedRegion());

	my_registration->SetMetric(my_metric); 
	my_registration->SetOptimizer(my_optimizer); 
	my_registration->SetInterpolator(my_interpolator); 
	my_registration->SetTransform(my_transform); 

  	my_registration->SetInitialTransformParameters(my_initialTransformParameters);

	my_interpolator->SetInputImage(my_movingImage); 
	my_metric->SetNumberOfSpatialSamples(my_numberOfSamples); 

	// set up optimizer
	my_optimizer->SetNormalVariateGenerator(GeneratorType::New());
      	my_optimizer->SetMaximumIteration(my_numberOfIterations);
        my_optimizer->SetEpsilon(my_epsilonFunction);
        my_optimizer->Initialize(1.01); // Initial search radius
      	my_optimizer->SetScales( my_optimizerScales );

	CommandIterationUpdate::Pointer observer = CommandIterationUpdate::New();
	my_optimizer->AddObserver( itk::IterationEvent(), observer );

	std::cout << "DEBUG: Rigid: INITIAL versor transform: "
            		<< std::endl
            		<< my_registration->GetInitialTransformParameters() << std::endl ;
	
	my_registration->Initialize();

	try
	{
		std::cout<<"Registering..."<<std::endl;
		my_registration->StartRegistration(); 
	}
	catch( itk::ExceptionObject &e )
	{
		e.Print (std::cout);
		ErrorWindow *error = new ErrorWindow((char*)e.GetDescription ());
		error->Show();
		return(false);
	}
	catch( ... )
	{
		char *errorString = "Unknown exception caught in LandmarkRegistrator:";
		ErrorWindow *error = new ErrorWindow(errorString);
		error->Show(); 
		return(false);
	}
  	
 	my_finalTransform->SetIdentity();
  	my_finalTransform->SetCenter(my_transform->GetCenter());
  	my_finalTransform->SetMatrix(my_transform->GetRotationMatrix());
  	my_finalTransform->SetOffset(my_transform->GetOffset());
	return(true);
}

void RigidRegistration::SetNumberOfSamples(unsigned int samples)
{
	my_numberOfSamples = samples;
}

unsigned int RigidRegistration::numberOfSamples()
{
	return my_numberOfSamples;
}

unsigned long RigidRegistration::numberOfIterations() const
{
  return my_numberOfIterations;
}

void RigidRegistration::SetNumberOfIterations(unsigned int iters)
{
	my_numberOfIterations = iters;
}

double RigidRegistration::rotationScale() const
{
  	return my_rotationScale;
}


void RigidRegistration::SetRotationScale(double theValue)
{
  my_rotationScale = theValue;
}


double RigidRegistration::translationScale() const
{
  return my_translationScale;
}


void RigidRegistration::SetTranslationScale(double theValue)
{
  my_translationScale = theValue;
}

double RigidRegistration::epsilonFunction() const
{
  return my_epsilonFunction;
}


void RigidRegistration::SetEpsilonFunction(double epsilon)
{
	my_epsilonFunction = epsilon; 
} 


