//
// C++ Implementation: vtktoitk
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "vtktoitk.h"

vtkToItk::vtkToItk()
{
}


vtkToItk::~vtkToItk()
{
}

vtkToItk::ConverntToITK(char *filename)
{
	slcReader = vtkSLCReader::New();
	slcReader->SetFileName(filename); 
	vtkExporter = vtkImageExport::New();
	vtkExporter->SetInput(slcReader->GetOutput());
	itkImporter = ImageImportType::New();
	ConnectPipelines(vtkExporter, itkImporter);
	itkImage->SetInput(itkImporter->GetOutput());

}

/**
 * This function will connect the given vtkImageExport filter to
 * the given itk::VTKImageImport filter.
 */
void ConnectPipelines(VTK_Exporter* exporter, ITK_Importer importer)
{
  importer->SetUpdateInformationCallback(exporter->GetUpdateInformationCallback());
  importer->SetPipelineModifiedCallback(exporter->GetPipelineModifiedCallback());
  importer->SetWholeExtentCallback(exporter->GetWholeExtentCallback());
  importer->SetSpacingCallback(exporter->GetSpacingCallback());
  importer->SetOriginCallback(exporter->GetOriginCallback());
  importer->SetScalarTypeCallback(exporter->GetScalarTypeCallback());
  importer->SetNumberOfComponentsCallback(exporter->GetNumberOfComponentsCallback());
  importer->SetPropagateUpdateExtentCallback(exporter->GetPropagateUpdateExtentCallback());
  importer->SetUpdateDataCallback(exporter->GetUpdateDataCallback());
  importer->SetDataExtentCallback(exporter->GetDataExtentCallback());
  importer->SetBufferPointerCallback(exporter->GetBufferPointerCallback());
  importer->SetCallbackUserData(exporter->GetCallbackUserData());
}


