//
// C++ Interface: vtktoitk
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef VTKTOITK_H
#define VTKTOITK_H

#include "vtkSphereSource.h"
#include "vtkVolumeTextureMapper2D.h"
//#include "vtkVolumeTextureMapper3D.h"
#include "vtkColorTransferFunction.h"
#include "vtkActor.h"
#include "vtkRenderWindow.h"
#include "vtkRenderer.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkSLCReader.h"
#include "vtkPiecewiseFunction.h"
#include "vtkVolumeProperty.h"

#include "itkCommand.h"
#include "itkImage.h"
#include "itkVTKImageExport.h"
#include "itkVTKImageImport.h"
#include "itkCurvatureFlowImageFilter.h"

#include "vtkImageImport.h"
#include "vtkImageExport.h"
#include "vtkImageData.h"

/**
	@author 
*/
class vtkToItk{
public:
    
	typedef short ImagePixelType;
	typedef itk::Image<ImagePixelType,3>  ImageType;
	typedef ImageType::Pointer            ImagePointer;
	typedef itk::VTKImageImport<ImageType> ImageImportType;

 	vtkSLCReader *slcReader;
	vtkVolume *volume;
	
	vtkToItk();
	~vtkToItk();	
	void ReadVTKFile(char*); 
	ImagePointer ConverToITK();

};

#endif
