//
// C++ Implementation: affineregistration
//
// Description: 
//
//
// Author:  Marta Kersten, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "affineregistration.h"

AffineRegistration::AffineRegistration()
{
	my_fixedImage = 0; 
	my_movingImage = 0; 
	
	// set dynamic range of translations and rotations to
	SetTranslationScale(1.0); 
	SetRotationScale(100.0); 

	// set registration parameters to defaults
	SetNumberOfIterations(5000); 
	SetEpsilonFunction(1e-10); 
	SetNumberOfSamples(40000);
	
	my_metric = MetricType::New(); 
	my_transform = TransformType::New();
	my_optimizer = OptimizerType::New(); 
	my_generator = GeneratorType::New();
	my_registration = RegistrationType::New(); 	
	my_resampleFilter = ResampleFilterType::New();
	my_finalTransform = AffineTransformType::New(); 
	my_interpolator = InterpolatorType::New();

	my_transform->SetIdentity();
	my_initialTransformParameters = my_transform->GetParameters();
//	my_initializer = TransformInitializerType::New();

	my_optimizerScales.set_size(15) ; 
	my_optimizerScales[0] = 200; // rotations
	my_optimizerScales[1] = 200;
	my_optimizerScales[2] = 200;
	my_optimizerScales[3] = 1;  // offset
	my_optimizerScales[4] = 1;
	my_optimizerScales[5] = 1;
	my_optimizerScales[6] = 300;  // scale
	my_optimizerScales[7] = 300;
	my_optimizerScales[8] = 300;
	my_optimizerScales[9] = 400; // skew
	my_optimizerScales[10] = 400;
	my_optimizerScales[11] = 400;
	my_optimizerScales[12] = 400; // skew
	my_optimizerScales[13] = 400;
	my_optimizerScales[14] = 400;
}


AffineRegistration::~AffineRegistration()
{
}

bool AffineRegistration::Register()
{

	std::cout<<"Transform params: "<< my_transform->GetNumberOfParameters() <<std::endl;

	my_interpolator->SetInputImage(my_movingImage); 
	my_metric->SetNumberOfSpatialSamples(my_numberOfSamples); 

	// set up optimizer 
	my_optimizer->SetNormalVariateGenerator(my_generator);
      	my_optimizer->SetMaximumIteration(500);
        my_optimizer->SetEpsilon(my_epsilonFunction);
        my_optimizer->Initialize(1.01); // Initial search radius
      	my_optimizer->SetScales( my_optimizerScales );
	my_optimizer->SetCostFunction(my_metric);

	// ITK transforms the fixed image into the moving image
	my_registration->SetMovingImage(my_fixedImage) ;     
	my_registration->SetFixedImage(my_movingImage);  
	
	my_registration->SetFixedImageRegion(my_movingImage->GetLargestPossibleRegion());

/*	my_initializer->SetTransform(my_transform);
	my_initializer->SetMovingImage(my_movingImage);
	my_initializer->SetFixedImage(my_fixedImage);
	my_initializer->MomentsOn();
	my_initializer->InitializeTransform();*/

	my_registration->SetMetric(my_metric); 
	my_registration->SetOptimizer(my_optimizer); 
	my_registration->SetInterpolator(my_interpolator); 
	my_registration->SetTransform(my_transform); 
	my_registration->SetInitialTransformParameters(my_initialTransformParameters);
  	
	try
	{
		my_registration->StartRegistration(); 
	}
	catch( itk::ExceptionObject &e )
	{
		e.Print (std::cout);
		ErrorWindow *error = new ErrorWindow((char*)e.GetDescription ());
		error->Show();
		return(false);
	}
	catch( ... )
	{
		char *errorString = "Unknown exception caught in LandmarkRegistrator:";
		ErrorWindow *error = new ErrorWindow(errorString);
		error->Show(); 
		return(false);
	}
  	
 	my_finalTransform->SetIdentity();
  	my_finalTransform->SetCenter(my_transform->GetCenter());
  	my_finalTransform->SetMatrix(my_transform->GetMatrix());
  	my_finalTransform->SetOffset(my_transform->GetOffset());
	return(true);

}

void AffineRegistration::SetNumberOfSamples(unsigned int samples)
{
	my_numberOfSamples = samples;
} 

unsigned int AffineRegistration::numberOfSamples()
{
	return my_numberOfSamples;
}

unsigned long AffineRegistration::numberOfIterations() const
{
  return my_numberOfIterations;
}

void AffineRegistration::SetNumberOfIterations(unsigned int iters)
{
	my_numberOfIterations = iters;
}

double AffineRegistration::rotationScale() const
{
  return my_rotationScale;
}


void AffineRegistration::SetRotationScale(double theValue)
{
  my_rotationScale = theValue;
}


double AffineRegistration::translationScale() const
{
  return my_translationScale;
}


void AffineRegistration::SetTranslationScale(double theValue)
{
  my_translationScale = theValue;
}

double AffineRegistration::epsilonFunction() const
{
  return my_epsilonFunction;
}


void AffineRegistration::SetEpsilonFunction(double epsilon)
{
	my_epsilonFunction = epsilon; 
} 
