//
// C++ Interface: affineregistration
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef AFFINEREGISTRATION_H
#define AFFINEREGISTRATION_H

/**
	@author 
*/


#include "itkImage.h"
#include "itkResampleImageFilter.h"
#include "itkLinearInterpolateImageFunction.h"
#include "itkEuclideanDistancePointMetric.h" 
#include "itkScaleSkewVersor3DTransform.h"
#include "itkLeastSquaredDistanceCostFunction.h"
#include "itkOnePlusOneEvolutionaryOptimizer.h"
#include "itkNormalVariateGenerator.h" 
#include "itkPointSetToPointSetRegistrationMethod.h" 
#include "itkObject.h"
#include "itkImageRegistrationMethod.h"
#include "itkMattesMutualInformationImageToImageMetric.h"
#include "itkAffineTransform.h"
#include "itkCenteredAffineTransform.h"
#include "itkCenteredTransformInitializer.h"
#include "errorwindow.h" 

class AffineRegistration{
public:
    	AffineRegistration();
    	~AffineRegistration();

	typedef short PixelType;
	typedef itk::Image < PixelType, 3 > FixedImageType;
	typedef itk::Image < PixelType, 3 > MovingImageType; 	

	FixedImageType::Pointer my_fixedImage; 
	MovingImageType::Pointer my_movingImage;

	// interpolator 
	typedef itk::LinearInterpolateImageFunction <MovingImageType, double> InterpolatorType;
	InterpolatorType::Pointer my_interpolator; 
	
	// transform
	//typedef itk::CenteredAffineTransform <double> TransformType;
	typedef itk::ScaleSkewVersor3DTransform <double> TransformType;
    	TransformType::Pointer      my_transform;
 
	// initializer 
	//typedef itk::CenteredTransformInitializer<TransformType, FixedImageType, MovingImageType> TransformInitializerType;
	//TransformInitializerType::Pointer my_initializer;

	// metric 
	typedef itk::MattesMutualInformationImageToImageMetric< FixedImageType, MovingImageType > MetricType;
	MetricType::Pointer my_metric;

	// registrator
	typedef itk::ImageRegistrationMethod<FixedImageType, MovingImageType> RegistrationType; 
	RegistrationType::Pointer my_registration; 

	// optimizer
	typedef itk::OnePlusOneEvolutionaryOptimizer OptimizerType;
	OptimizerType::Pointer      my_optimizer;
	OptimizerType::Pointer	    my_landmarkOptimizer;

	typedef itk::Statistics::NormalVariateGenerator	GeneratorType;
	GeneratorType::Pointer	my_generator;

    	typedef TransformType::ParametersType                 ParametersType;
   	typedef TransformType::ParametersType                 ScalesType;
	ParametersType              my_initialTransformParameters;
    	ScalesType                  my_optimizerScales;

	// resample filter
	typedef itk::ResampleImageFilter <MovingImageType, MovingImageType> ResampleFilterType; 
	ResampleFilterType::Pointer my_resampleFilter;

	// transform 
	typedef itk::AffineTransform <double> AffineTransformType; 
	AffineTransformType::Pointer my_finalTransform; 

	void SetEpsilonFunction(double theValue);
	double epsilonFunction() const;

	void SetNumberOfIterations(unsigned int theValue);
	unsigned long numberOfIterations() const;

	void SetRotationScale(double theValue);
	double rotationScale() const;

	void SetTranslationScale(double theValue);
	double translationScale() const;

	void SetNumberOfSamples(unsigned int samples); 
	unsigned int numberOfSamples(); 

	bool Register();

private: 
	
	unsigned long 	my_numberOfIterations; 
	double		my_epsilonFunction; 
	unsigned int 	my_numberOfSamples;
	
	double 		my_translationScale;
	double		my_rotationScale;


};

#endif
