//
// C++ Interface: guiaffineregistration
//
// Description: 
//
//
// Author: Marta Kersten <mkersten@schubert>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GUIAFFINEREGISTRATION_H
#define GUIAFFINEREGISTRATION_H

/**
@author Marta Kersten
*/

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Value_Input.H>
#include <FL/Fl_Output.H>
#include <FL/fl_file_chooser.H>

#include <cstdlib>
//  c/c++ includes
#include <iostream> 
#include <fstream> 


class guiAffineRegistration{
public:
   	
	guiAffineRegistration();
    	virtual ~guiAffineRegistration();

    	Fl_Window *AffineRegWindow;

	Fl_Button* close;

	Fl_Group* mainGroup;
	Fl_Group* paramGroup;

	Fl_Value_Input* transScale; 
	Fl_Value_Input* rotScale; 
	Fl_Value_Input* numIter; 
	Fl_Value_Input* epsFunc;
	
	enum TypePointSet {FIXED = 0, MOVING = 1};

	void Show();
	void SetUp();


private:
	
	static void setTranslationScale_cb(Fl_Widget*, void*); 
	static void setRotationScale_cb(Fl_Widget*, void*); 
	static void setNumIterations_cb(Fl_Widget*, void*); 
	static void setEpsilonFunc_cb(Fl_Widget*, void*); 
	
	static void register_cb(Fl_Widget*, void*); 
	static void close_cb(Fl_Widget *w, void *p);


public:
	virtual void SetRotationScale(double scale); 
	virtual void SetTranslationScale(double scale); 
	virtual void SetNumIterations(long int number); 
	virtual void SetEpsilonFunction(double epsilon); 
	virtual void Register(); 

};
#endif
