//
// C++ Implementation: guiicp
//
// Description: This class creates the pop-up window for advanced options of the ICP algorithm.
// The implementation of the functions are in guiICPImplementation.cpp
//
// Author:  <Marta Kersten>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "guiicp.h"

guiICP::guiICP()
{	
	int xDim = 400; 
	int yDim = 200; 

	ICPWindow = new Fl_Window(xDim, yDim, "ICP Registration");
	// ICPWindow->box(FL_PLASTIC_UP_BOX);
	ICPWindow->resizable(); 
	ICPWindow->begin();

	mainGroup = new Fl_Group(0, 30, (xDim-10), (yDim-10)); 
	mainGroup->resizable();

	// input 
	selectFixedPoints  = new Fl_Button(15, 15, 130, 30, "Select Fixed Points... ");
	selectFixedPoints->labelsize(10);
	
	selectMovingPoints = new Fl_Button(15, 55, 130, 30, "Select Moving Points... "); 
	selectMovingPoints->labelsize(10);

	useVolMesh = new Fl_Button (15, 95, 130, 30, "Use Volume Surfaces");
	useVolMesh->labelsize(10); 

	int inputX = xDim-85;
	paramGroup = new Fl_Group(inputX, 15, 150, 130); 

	transScale = new Fl_Value_Input(inputX, 15, 60, 20, "Translation Scale:"); 
	transScale->labelsize(10); 

	rotScale = new Fl_Value_Input(inputX, 35, 60, 20, "Rotation Scale:"); 
	rotScale->labelsize(10);
	
	numIter = new Fl_Value_Input(inputX, 55, 60, 20, "Number Iterations:"); 
	numIter->labelsize(10); 

	gradTol = new Fl_Value_Input(inputX, 75, 60, 20, "Gradient Tolerance:");
	gradTol->labelsize(10); 
	
	valTol = new Fl_Value_Input(inputX, 95, 60, 20, "Value Tolerance:");
	valTol->labelsize(10);  
	
	epsFunc = new Fl_Value_Input(inputX, 115, 60, 20, "Epsilon Function:");
	epsFunc->labelsize(10);
	
	paramGroup->end();

	/*int yOutputBox = yDim/2;

	// output
	outputGroup = new Fl_Group(15, yOutputBox, 190, 120, "Registration Output");
	outputGroup->box(FL_ENGRAVED_FRAME);
	
	transOutputGroup = new Fl_Group(30, yOutputBox+20, 75, 80, "Translation");
	transOutputGroup->labelsize(12); 
	transOutputGroup->box(FL_ENGRAVED_FRAME);
	
	xTrans = new Fl_Output(50, yOutputBox+30, 50, 20, "X"); 
	yTrans = new Fl_Output(50, yOutputBox+50, 50, 20, "Y"); 
	zTrans = new Fl_Output(50, yOutputBox+70, 50, 20, "Z"); 

	rotOutputGroup = new Fl_Group( 120, yOutputBox+20, 75, 80, "Rotation");
	rotOutputGroup->labelsize(12); 
	rotOutputGroup->box(FL_ENGRAVED_FRAME);
		
	xRot = new Fl_Output(140, yOutputBox+30, 50, 20, "X"); 
	yRot = new Fl_Output(140, yOutputBox+50, 50, 20, "Y"); 
	zRot = new Fl_Output(140, yOutputBox+70, 50, 20, "Z"); 
        
	outputGroup->end(); */
	// actions
	/*reg   = new Fl_Button( 15, yDim-30, 70, 20, "Register");
	reg->box(FL_PLASTIC_UP_BOX);
	reg->down_box(FL_PLASTIC_DOWN_BOX); 
	reg->color(63); 
	reg->selection_color(63);
	reg->labelsize(10); */

      	close = new Fl_Button(inputX, yDim-30, 70, 20, "Ok");
	close->box(FL_PLASTIC_UP_BOX);
	close->down_box(FL_PLASTIC_DOWN_BOX);
	close->labelsize(10); 
	
	mainGroup->end();
	ICPWindow->end();
	
	transScale->callback(setTranslationScale_cb, this);
	rotScale->callback(setRotationScale_cb, this);
	numIter->callback(setNumIterations_cb, this);  
	gradTol->callback(setGradTolerance_cb, this); 
	valTol->callback(setValTolerance_cb, this); 
	epsFunc->callback(setEpsilonFunc_cb, this); 

	selectFixedPoints->callback(selectFixedPointFile_cb, this); 
	selectMovingPoints->callback(selectMovingPointFile_cb, this);

	close->callback(close_cb, this);
	//reg->callback(register_cb, this); 
	
}

guiICP::~guiICP()
{
}

void guiICP::Show()
{
	ICPWindow->show();
}


void guiICP::close_cb(Fl_Widget *w, void *p) 
{ 
	((guiICP *) p)->ICPWindow->hide(); 
}

void guiICP::setTranslationScale_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiICP *) p)->SetTranslationScale(b->value());
}

void guiICP::setRotationScale_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiICP *) p)->SetRotationScale(b->value());
} 

void guiICP::setNumIterations_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiICP *) p)->SetNumIterations((long int)b->value());
}

void guiICP::setGradTolerance_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiICP *) p)->SetGradientTolerance(b->value());
}

void guiICP::setValTolerance_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiICP *) p)->SetValueTolerance(b->value());
} 

void guiICP::setEpsilonFunc_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiICP *) p)->SetEpsilonFunction(b->value());
}


void guiICP::register_cb( Fl_Widget* , void*p)
{
	((guiICP *) p)->Register();
}

void guiICP::selectFixedPointFile_cb(Fl_Widget* o, void*p)
{
	((guiICP *) p)->ReadPointsFile(FIXED); 
}

void guiICP::selectMovingPointFile_cb(Fl_Widget* o, void*p)
{
	((guiICP *) p)->ReadPointsFile(MOVING); 
}


void guiICP::ReadPointsFile(int type) { }

void guiICP::SetRotationScale(double scale) { } 
void guiICP::SetTranslationScale(double scale) { }
void guiICP::SetNumIterations(long int number) { }
void guiICP::SetGradientTolerance(double tolerance) { } 
void guiICP::SetValueTolerance(double tolerance){ }
void guiICP::SetEpsilonFunction(double epsilon) { }

bool guiICP::Register() { }

void guiICP::GetRegTransform() { }




