//
// C++ Interface: guiicp
//
// Description: 
//
//
// Author:  <>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GUIICP_H
#define GUIICP_H

/**
@author 
*/

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Value_Input.H>
#include <FL/Fl_Output.H>
#include <FL/fl_file_chooser.H>

#include <cstdlib>
//  c/c++ includes
#include <iostream> 
#include <fstream> 


class guiICP{
public:
	guiICP();
	virtual ~guiICP();

	Fl_Window *ICPWindow;

	Fl_Button* reg;
      	Fl_Button* close;
	
	Fl_Button* selectFixedPoints;
	Fl_Button* selectMovingPoints;   
	Fl_Button* useVolMesh;	

	Fl_Group* mainGroup;
	Fl_Group* paramGroup;
	Fl_Group* outputGroup;
	Fl_Group* transOutputGroup;
	Fl_Group* rotOutputGroup;

	Fl_Value_Input* transScale; 
	Fl_Value_Input* rotScale; 
	Fl_Value_Input* numIter; 
	Fl_Value_Input* gradTol;
	Fl_Value_Input* valTol; 
	Fl_Value_Input* epsFunc;
	
	//setUseCostFunctionGradient(false);
	//my_calculateDistanceMap = false; 

	Fl_Output* xTrans; 
	Fl_Output* yTrans;
	Fl_Output* zTrans;

	Fl_Output* xRot;
	Fl_Output* yRot;
	Fl_Output* zRot;
	

	enum TypePointSet {FIXED = 0, MOVING = 1};

	void Show(); 

private:
	static void selectFixedPointFile_cb(Fl_Widget* , void*); 
	static void selectMovingPointFile_cb(Fl_Widget* , void*); 
	
	static void setTranslationScale_cb(Fl_Widget*, void*); 
	static void setRotationScale_cb(Fl_Widget*, void*); 
	static void setNumIterations_cb(Fl_Widget*, void*); 
	static void setGradTolerance_cb(Fl_Widget*, void*); 
	static void setValTolerance_cb(Fl_Widget*, void*); 
	static void setEpsilonFunc_cb(Fl_Widget*, void*); 
	
	static void close_cb(Fl_Widget* , void*);
	static void register_cb(Fl_Widget*, void*); 


public:
	virtual void ReadPointsFile(int fixedOrMoving); 
	virtual void SetRotationScale(double scale); 
	virtual void SetTranslationScale(double scale); 
	virtual void SetNumIterations(long int number); 
	virtual void SetGradientTolerance(double tolerance);
	virtual void SetValueTolerance(double tolerence); 
	virtual void SetEpsilonFunction(double epsilon); 
	virtual bool Register(); 

	virtual void GetRegTransform();
	

};

#endif
