//
// C++ Implementation: guiicpimplementation
//
// Description: This is the implementation of the pop-up window for the advanced
// options of the ICP algorithm. It allows for setting of the options
// of the ICP registration with is implemented in icp.cpp
//
// Author:  <Marta Kersten>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "guiicpimplementation.h"

guiICPImplementation::guiICPImplementation()
{
	icp = new ICP(); 
}

guiICPImplementation::~guiICPImplementation()
{
}

void guiICPImplementation::SetUp()
{
	transScale->value(this->icp->translationScale()); 
	rotScale->value(this->icp->rotationScale()); 
	numIter->value(this->icp->numberOfIterations()); 
	gradTol->value(this->icp->gradientTolerance());
	valTol->value(this->icp->valueTolerance());
	epsFunc->value(this->icp->epsilonFunction()); 

}
void guiICPImplementation::SetRotationScale(double scale)
{
	this->icp->setRotationScale(scale); 
} 
void guiICPImplementation::SetTranslationScale(double scale) 
{ 
	this->icp->setTranslationScale(scale);
}

void guiICPImplementation::SetNumIterations(long int number) 
{ 
	this->icp->setNumberOfIterations(number); 
}

void guiICPImplementation::SetGradientTolerance(double tolerance) 
{
	this->icp->setGradientTolerance(tolerance); 
} 

void guiICPImplementation::SetValueTolerance(double tolerance)
{ 
	this->icp->setValueTolerance(tolerance); 
}

void guiICPImplementation::SetEpsilonFunction(double epsilon) 
{
	this->icp->setEpsilonFunction(epsilon); 
}

void guiICPImplementation::ReadPointsFile(int pointSetType)
{	
	const char * filename = fl_file_chooser("Choose a points file...","*.txt?","");

	if ( !filename )
	{
		return;
	}
		
/*	if ( m_FixedImageFileName !=  fileName )
	{
		this->HandleInputImageChange(fileName, true);
	}
*/
	PointType point; 
	PointsContainer::Pointer pointContainer  = PointsContainer::New(); 

	// read in file with fixed points
	std::ifstream pointFile;
	pointFile.open(filename);
	if(pointFile.fail())
	{
		std::cerr << "Error opening points file with name: " << filename << std::endl; 
		return; 
	}

	unsigned int pointId = 0; 
	pointFile >> point; 
	while ( !pointFile.eof() )
	{
		pointContainer->InsertElement(pointId, point); 
		pointFile >> point; 
		pointId++; 
	}

	if (pointSetType == FIXED)
		this->icp->my_fixedPointSet->SetPoints(pointContainer);  
	else
		this->icp->my_movingPointSet->SetPoints(pointContainer); 

}

void guiICPImplementation::Quit()
{
//	ICPWindow->hide();
//	exit(0);
}

bool guiICPImplementation::Register()
{
	if (this->icp->my_fixedPointSet->GetNumberOfPoints() == 0) 
	{
		char *errorString = "Fixed points file has not been set. Please select fixed point file.";
		ErrorWindow *error = new ErrorWindow(errorString);
		error->Show();
		return false; 
	}
	
	if (this->icp->my_movingPointSet->GetNumberOfPoints() == 0) 
	{
		char *errorString =  "Moving points file has not been set. Please select fixed points file"; 
		ErrorWindow *error = new ErrorWindow(errorString);
		error->Show();
		return false; 
	}
	
  	fl_cursor(Fl_Cursor(FL_CURSOR_WAIT), (Fl_Color) 56, (Fl_Color) 255);

	this->icp->Register(); 

	fl_cursor(Fl_Cursor(FL_CURSOR_DEFAULT), (Fl_Color) 56, (Fl_Color) 255);
	return true; 

}

void guiICPImplementation::GetRegTransform()
{
	double xTransVal, yTransVal, zTransVal;
	double xRotVal, yRotVal, zRotVal;
	
	xTransVal = this->icp->my_registration->GetLastTransformParameters()[0];
	yTransVal = this->icp->my_registration->GetLastTransformParameters()[1];
	zTransVal = this->icp->my_registration->GetLastTransformParameters()[2];
		
	xRotVal = this->icp->my_registration->GetLastTransformParameters()[3];
	yRotVal = this->icp->my_registration->GetLastTransformParameters()[4];
	zRotVal = this->icp->my_registration->GetLastTransformParameters()[5];

	char xTransStr[15];
	char yTransStr[15];
	char zTransStr[15];

	sprintf(xTransStr, "%5.2f", xTransVal);
	//gcvt(xTransVal, 6, xTransStr);
	sprintf(yTransStr, "%5.2f", yTransVal);
	sprintf(zTransStr, "%5.2f", zTransVal);
	
	std::cout<< "x : " << xTransStr << " y: " << yTransStr << " z: " << zTransStr <<std::endl;

	char xRotStr[15];
	char yRotStr[15];
	char zRotStr[15];
	
	sprintf(xRotStr, "%5.2f", xRotVal);
	sprintf(yRotStr, "%5.2f", yRotVal);
	sprintf(zRotStr, "%5.2f", zRotVal);
	
	xTrans->value(xTransStr);
	yTrans->value(yTransStr);
	zTrans->value(zTransStr);
	
	xRot->value(xRotStr);
	yRot->value(yRotStr);
	zRot->value(zRotStr);

	std::cout<< "x : " << xRotStr << " y: " << yRotStr << " z: " << zRotStr <<std::endl;

}
