//
// C++ Interface: guiicpimplementation
//
// Description: 
//
//
// Author:  <>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GUIICPIMPLEMENTATION_H
#define GUIICPIMPLEMENTATION_H

/**
@author 
*/

#include "itkPointSet.h" 
#include "errorwindow.h"
#include "icp.h" 
#include "guiicp.h"

class guiICPImplementation : public guiICP
{

public:
	guiICPImplementation();
	~guiICPImplementation();

	ICP *icp;
	
	char *my_FixedPointsFile; 
	char *my_MovingPointsFile; 

	typedef itk::PointSet < float, 3 > 	PointSetType; 
	typedef PointSetType::PointType		PointType;
	typedef PointSetType::PointsContainer	PointsContainer;

	void SetUp(); 
	void SetRotationScale(double scale); 
	void SetTranslationScale(double scale); 
	void SetNumIterations(long int number); 
	void SetGradientTolerance(double tolerance);
	void SetValueTolerance(double tolerence); 
	void SetEpsilonFunction(double epsilon); 
	void ReadPointsFile(int pointSetType); 
	bool Register(); 
	void GetRegTransform();
	void Quit(); 
	void Close(); 
};

#endif
