//
// C++ Interface: guimain
//
// Description: 
//
//
// Author:  <>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GUIMAIN_H
#define GUIMAIN_H


#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Round_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Value_Input.H>
#include <FL/Fl_Output.H>
#include <FL/fl_file_chooser.H>
#include <FL/Fl_Value_Slider.H>
#include <FL/Fl_Menu_Bar.H>

#include "sliceviewer.h"
#include "GLTwoImageSliceView.h"

#include <cstdlib>
//  c/c++ includes
#include <iostream> 
#include <fstream> 

/**
@author 
*/
class guiMain
{
  public:
    	guiMain();
    	virtual ~guiMain();
	
	Fl_Window *mainWindow;

	Fl_Group *mainGroup;
	Fl_Group *inputImagesGroup;

	Fl_Group *fixedViewAxisGroup; 
	Fl_Round_Button *fixedViewAxisX; 
	Fl_Round_Button *fixedViewAxisY; 
	Fl_Round_Button *fixedViewAxisZ; 

	Fl_Group *fixedImageGroup; 
	SliceViewer < short > *fixedImageViewer; 
	Fl_Button *selectFixedImage; 	
	Fl_Button *loadFixedLandmarks; 
	Fl_Button *saveFixedLandmarks;
	Fl_Button *addFixedLandmark; 
	Fl_Button *clearFixedLandmarks; 
	Fl_Value_Slider *fixedSliceSlider;

	Fl_Group *movingViewAxisGroup; 
	Fl_Round_Button *movingViewAxisX; 
	Fl_Round_Button *movingViewAxisY; 
	Fl_Round_Button *movingViewAxisZ; 

	Fl_Group *movingImageGroup;  
	Fl_Button *selectMovingImage; 
	Fl_Button *loadMovingLandmarks; 
	Fl_Button *saveMovingLandmarks;
	Fl_Button *addMovingLandmark;
	Fl_Button *clearMovingLandmarks; 
	SliceViewer < short > *movingImageViewer; 
	Fl_Value_Slider *movingSliceSlider;
	
	Fl_Group *resultImageGroup;
	GLTwoImageSliceView< short, unsigned char > *resultImageViewer;
	Fl_Value_Slider *resultSliceSlider;

	/* DISPLAY IMAGE MENU*/
	static Fl_Menu_Item menu_viewDisplayImageChoice[];	
	static Fl_Menu_Item *registeredView; 
	static Fl_Menu_Item *unregisteredView; 
	static Fl_Menu_Item  *movingImageView;
	static Fl_Menu_Item  *fixedImageView;
	static Fl_Menu_Item *initializedView;
	Fl_Choice *displayImageChoice; 

	/* INITIALIZATION CHOICE MENU */
	static Fl_Menu_Item menu_initializationChoice[];
	static Fl_Menu_Item *noInitialization;
	static Fl_Menu_Item *landmarkInitialization;
	static Fl_Menu_Item *momentsInitialization;
	Fl_Choice *initializationChoice;
	
	/* REGISTRATION CHOICE  MENU*/
	static Fl_Menu_Item menu_registrationChoice[];
	static Fl_Menu_Item *noRegistration;
	static Fl_Menu_Item *rigidRegistration;
	static Fl_Menu_Item *affineRegistration;
	static Fl_Menu_Item *ICPRegistration;
	Fl_Choice *registrationChoice;

	Fl_Group *registerGroup; 
	Fl_Group *inputGroup; 
/*	Fl_Round_Button *icp; 
	Fl_Round_Button *landmark; 
	Fl_Round_Button *mutualInfo; 
	Fl_Round_Button *moments;*/

	Fl_Button* advancedRegOptions; 
	Fl_Button* advancedInitOptions; 

	Fl_Button* reg;
	Fl_Group* outputGroup;
	Fl_Group* transOutputGroup;
	Fl_Group* rotOutputGroup;

	Fl_Output* xTrans; 
	Fl_Output* yTrans;
	Fl_Output* zTrans;

	Fl_Output* xRot;
	Fl_Output* yRot;
	Fl_Output* zRot;

 	Fl_Output *statusDisplay;

	enum ViewSetType {FIXED = 0, MOVING = 1, UNREGISTERED = 2, INITIALIZED = 3, REGISTERED = 4};
	enum InitialRegType { NONE = 0, LANDMARK = 1, MOMENTS = 3, ICP = 4, MUTUALINFO = 5, RIGID = 6, AFFINE = 7};
	unsigned int numFixedLandmarks;
	unsigned int numMovingLandmarks;


private:	
	/* VIEWING/VIEWERS */
	static void selectFixedImageFile_cb(Fl_Widget* , void*); 
	static void selectMovingImageFile_cb(Fl_Widget* , void*); 

	static void updateMovingSliceNumber_cb(Fl_Widget* , void*); 
	static void updateFixedSliceNumber_cb(Fl_Widget* , void*); 
	static void updateResultSliceNumber_cb(Fl_Widget* , void*); 

	static void changeFixedViewAxisX_cb(Fl_Widget*, void*); 
	static void changeFixedViewAxisY_cb(Fl_Widget*, void*); 
	static void changeFixedViewAxisZ_cb(Fl_Widget*, void*); 

	static void changeMovingViewAxisX_cb(Fl_Widget*, void*); 
	static void changeMovingViewAxisY_cb(Fl_Widget*, void*); 
	static void changeMovingViewAxisZ_cb(Fl_Widget*, void*); 

	/* LANDMARK RELATED*/
	static void addLandmark_cb(Fl_Widget*, void*); 
	static void loadFixedLandmarks_cb(Fl_Widget*, void*);
	static void loadMovingLandmarks_cb(Fl_Widget*, void*);
	static void saveFixedLandmarks_cb(Fl_Widget*, void*); 
	static void saveMovingLandmarks_cb(Fl_Widget*, void*);
	static void clearFixedLandmarks_cb(Fl_Widget*, void*); 
	static void clearMovingLandmarks_cb(Fl_Widget*, void*); 

	/* VIEWING IMAGES*/
	static void setUnregisteredView_cb(Fl_Menu_*, void*); 
	static void setInitializedView_cb(Fl_Menu_*, void*); 
	static void setRegisteredView_cb(Fl_Menu_*, void*); 
	static void setMovingImageView_cb(Fl_Menu_*, void*); 
	static void setFixedImageView_cb(Fl_Menu_*, void*);
	static void setDisplayMovingImage_cb(Fl_Widget*, void*); 
	static void setDisplayImageChoice_cb(Fl_Widget*, void*); 

	/*INITIALIZATION METHOD */
	static void setInitializationNone_cb(Fl_Menu_*, void*);
	static void setInitializationLandmark_cb(Fl_Menu_*, void*);
	static void setInitializationMoments_cb(Fl_Menu_*, void*);
	static void setInitializationChoice_cb(Fl_Widget*, void*);

	/* REGISTRATION METH0D */
	static void setRegistrationRigid_cb(Fl_Menu_*, void*); 
	static void setRegistrationAffine_cb(Fl_Menu_*, void*); 
	static void setRegistrationICP_cb(Fl_Menu_*, void*); 
	static void setRegistrationNone_cb(Fl_Menu_*, void*); 
//	static void setRegistrationAlgorithm_cb(Fl_Widget*, void*);  
	static void setRegistrationChoice_cb(Fl_Widget*, void*); 
	//static void setRegistrationAlgorithmMUTUALINFO_cb(Fl_Widget*, void*); 
	//static void setRegistrationAlgorithmMOMENTS_cb(Fl_Widget*, void*); 

	static void register_cb(Fl_Widget*, void*); 
	static void showAdvancedRegOptions_cb(Fl_Widget*, void*); 
	static void showAdvancedInitOptions_cb(Fl_Widget*, void*); 

public:
	virtual void SelectImage(int isFixedImage); 
	virtual void UpdateMovingSliceView(); 
	virtual void UpdateFixedSliceView(); 
	virtual void UpdateResultSliceView();
 	virtual void SetFixedViewAxis(unsigned int axis);
	virtual void SetMovingViewAxis(unsigned int axis);
	virtual void SetView(unsigned int view);
	virtual void SetInitialization(unsigned int initializationChoice);  
	virtual void AddLandmark(Fl_Widget* w); 
	virtual void SetRegistrationAlgorithm(unsigned int algo); 
	virtual void LoadLandmarks(unsigned int fixedSet); 
	virtual void SaveLandmarks(unsigned int fixedSet); 
	virtual void ClearLandmarks(unsigned int fixedSet); 
	virtual void ShowAdvancedRegOptions(); 
	virtual void ShowAdvancedInitOptions(); 
	virtual void Register(); 
	virtual void Initialize();
	virtual void SetDisplayMovingImage();
	virtual void SetInitializationChoice();
	virtual void SetRegistrationChoice();
};

#endif
