//
// C++ Interface: guimainimplementation
//
// Description: 
//
//
// Author:  <>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GUIMAINIMPLEMENTATION_H
#define GUIMAINIMPLEMENTATION_H

/**
@author 
*/

#include "guimain.h"

// FLTK related includes...
#include <FL/Enumerations.H>
#include <FL/fl_file_chooser.H>

// ITK related includes....
#include <itkGradientMagnitudeImageFilter.h>
#include <itkAffineTransform.h>
#include <itkScalableAffineTransform.h>
#include <itkExceptionObject.h>
#include <itkResampleImageFilter.h>
#include <itkImageIOFactory.h>
#include <itkImageFileReader.h>
#include <itkImageFileWriter.h>
#include "itkSpatialObjectReader.h"
#include "itkSpatialObjectWriter.h"
#include "itkCastImageFilter.h"
#include "itkCheckerBoardImageFilter.h"
#include "itkExtractImageFilter.h" 
//#include "itkVTKImageToImageFilter.h"

#include "itkVTKImageExport.h"
#include "itkVTKImageImport.h"

/*#include "vtkSLCReader.h"
#include "vtkImageImport.h"
#include "vtkImageExport.h"
#include "vtkVolumeTextureMapper2D.h"
#include "vtkMapper.h"
#include "vtkDataSet.h"
#include "vtkImageData.h"
#include "vtkDataSetMapper.h"*/

#include "sliceviewer.h"
#include "landmarkregistrator.h"
#include "miregistration.h"
#include "guiicpimplementation.h"
#include "guilandregimplementation.h"
#include "guimiimplementation.h"
#include "errorwindow.h"
#include "momentregistrator.h"
#include "guirigidregimplementation.h"
#include "guiaffineregimplementation.h"

class guiMainImplementation : public guiMain 
{
public:
	guiMainImplementation();
	virtual ~guiMainImplementation();

	guiMain *mainWindow; 

	typedef short		              ImagePixelType;
	typedef itk::Image<ImagePixelType,3>  ImageType;
	typedef itk::Image<short,2>		Image2DType;
	typedef ImageType::Pointer            ImagePointer;
	
	typedef ImageType::RegionType         RegionType;
	typedef ImageType::IndexType          IndexType;
	typedef RegionType::SizeType          SizeType;
	typedef itk::Point<double,3>          PointType;
	
	typedef itk::ImageFileReader<ImageType>     ImageReaderType;
	typedef itk::ImageFileWriter<ImageType>     ImageWriterType;
	typedef itk::ImageFileWriter<Image2DType>   Image2DWriterType;

	typedef itk::CheckerBoardImageFilter <Image2DType> CheckerBoardFilterType;
	CheckerBoardFilterType::Pointer my_checkerboardFilter;

	typedef itk::ExtractImageFilter <ImageType, Image2DType> ExtractImageFilterType;
	ExtractImageFilterType::Pointer my_extractFilter;

	typedef SliceViewer<ImagePixelType> SliceViewType;
	typedef SliceViewType::LandmarkSpatialObjectType 
							LandmarkSpatialObjectType;
	typedef SliceViewType::LandmarkPointType        
							LandmarkPointType;
	typedef SliceViewType::LandmarkPointListType    
                                                LandmarkPointListType;

	typedef itk::AffineTransform <double, 3> AffineTransformType; 
	AffineTransformType::Pointer my_finalAffineTransform; 
	AffineTransformType::Pointer my_landmarkAffineTransform;
	AffineTransformType::Pointer my_momentsAffineTransform; 

  	
	typedef itk::VersorRigid3DTransform < double > LandmarkTransformType;
	LandmarkTransformType::Pointer my_landmarkRegTransform;
	typedef LandmarkTransformType::ParametersType	LandmarkParametersType;

	typedef itk::VersorRigid3DTransform<double> MomentsTransformType ;
	MomentsTransformType::Pointer my_momentsRegTransform; 		

	typedef itk::VersorRigid3DTransform < double > RigidTransformType;
    	RigidTransformType::Pointer  my_finalRigidTransform;

	typedef itk::Rigid3DTransform<double> TransformType;
	TransformType::Pointer my_rigidTransform; 

	typedef AffineTransformType::ParametersType     AffineParametersType ;
	typedef RigidTransformType::ParametersType	RigidParametersType ;
	
	typedef itk::ResampleImageFilter <ImageType, ImageType> FilterType; 
	FilterType::Pointer my_resampleFilter;

	typedef itk::CenteredTransformInitializer <RigidTransformType, ImageType, ImageType> TransformInitializerType; 
	TransformInitializerType::Pointer my_initializer;

 	typedef itk::LinearInterpolateImageFunction<ImageType, double> InterpolatorType;
	InterpolatorType::Pointer my_interpolator;

	SizeType my_fixedImageSize;
	SizeType my_movingImageSize;
	
	char* my_fixedImageFileName ;
	char* my_movingImageFileName ;
	
	ImageType::Pointer my_fixedImage ;
	ImageType::Pointer my_movingImage ;
	ImageType::Pointer my_initializedImage;
	ImageType::Pointer my_registeredImage;

	bool my_fixedImageLoaded;
	bool my_movingImageLoaded;

	int currentFixedSlice; 
	int currentMovingSlice; 
	int currentResultSlice;

 	LandmarkSpatialObjectType::Pointer 
                              my_fixedLandmarkSpatialObject ;
    	LandmarkSpatialObjectType::Pointer 
                              my_movingLandmarkSpatialObject ;	
	
	//LandmarkRegistrator *landReg;
	//MIRegistration	*miReg;
	
	guiICPImplementation *guiICP; 
	guiLandRegImplementation *guiLandReg;
	guiMIImplementation *guiMI; 
	MomentRegistrator *momentsReg;
	guiRigidRegImplementation *guiRigidReg;
	guiAffineRegImplementation *guiAffineReg;	

	int my_fixedViewAxis;
	int my_movingViewAxis;
	unsigned int my_registrationAlgorithm; 
	unsigned int my_initializationAlgorithm;

	void SelectImage(int isFixedImage); 
	void HandleInputImageChange(char *fileName, int isFixedImage); 
	ImagePointer LoadImage(char *fileName); 

	void UpdateMovingSliceView(); 
	void UpdateFixedSliceView(); 
	void UpdateResultSliceView(); 
	void UpdateMovingSliceView(int slice); 
	void UpdateFixedSliceView(int slice); 
	void UpdateResultSliceView(int slice); 

    	void ChangeStatusDisplay(const char* message) ;
	void ShowAdvancedRegOptions();
    	void ShowAdvancedInitOptions();

	void SetFixedViewAxis(unsigned int axis);	
	void SetMovingViewAxis(unsigned int axis);	
	
	void SetView(unsigned int view); 
	void Show(); 
	void SetInitialization(unsigned int init);

	void LoadLandmarks(unsigned int isFixed); 
	void SaveLandmarks(unsigned int isFixed); 
	void AddLandmark(Fl_Widget *w); 
	void ClearLandmarks(unsigned int view);

	void Initialize();
	void Register(); 

private: 

//	void ConvertVTKtoITK(char* filename, int fixed);	
	void SetRegistrationAlgorithm(unsigned int algo);

	void GetInitializationTransform();
	void GetRegistrationTransform(); 
//	void ResampleFinalRegisteredImage(ImageType *input, ImageType *output);
	void ResampleFinalRegisteredImage();
};

#endif
