//
// C++ Implementation: guimi
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "guimi.h"

guiMI::guiMI()
{
	int xDim = 230; 
	int yDim = 200; 

	MIWindow = new Fl_Window(xDim, yDim, "Landmark Registration");
	MIWindow->resizable(); 
	MIWindow->begin();

	mainGroup = new Fl_Group(0, 10, (xDim-10), (yDim-10)); 
	mainGroup->resizable();

	int inputX = xDim - 100;
//	paramGroup = new Fl_Group(inputX, 10, 150, 130); 

	numBins = new Fl_Value_Input(inputX, 15, 60, 20, "Number of Bins:"); 
	numBins->labelsize(10); 

	numSamples = new Fl_Value_Input(inputX, 35, 60, 20, "Number of Samples:"); 
	numSamples->labelsize(10);
	
	numIter = new Fl_Value_Input(inputX, 55, 60, 20, "Number Iterations:"); 
	numIter->labelsize(10); 

	relaxFactor = new Fl_Value_Input(inputX, 75, 60, 20, "Relaxation Factor:");
	relaxFactor->labelsize(10);

	minStep = new Fl_Value_Input(inputX, 95, 60, 20, "Min Step Length:");
	minStep->labelsize(10);

	maxStep = new Fl_Value_Input(inputX, 115, 60, 20, "Max Step Length:");
	maxStep->labelsize(10);
	
//	paramGroup->end();

	// actions
	close = new Fl_Button( xDim-75, yDim-30, 70, 20, "Ok");
	close->box(FL_PLASTIC_UP_BOX);
	close->down_box(FL_PLASTIC_DOWN_BOX); 
	close->labelsize(10); 
	
	mainGroup->end();
	MIWindow->end();
	
	numBins->callback(setNumberOfBins_cb, this);
	numSamples->callback(setNumberOfSamples_cb, this);
	numIter->callback(setNumberOfIterations_cb, this);  
	relaxFactor->callback(setRelaxFactor_cb, this); 
	minStep->callback(setMinStep_cb, this); 
	maxStep->callback(setMaxStep_cb, this); 

	close->callback(close_cb, this); 

}


guiMI::~guiMI()
{
}

void guiMI::Show()
{
	MIWindow->show();
}


void guiMI::close_cb(Fl_Widget *w, void *p)
{
	((guiMI *) p)->MIWindow->hide(); 
}

void guiMI::setNumberOfBins_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiMI *) p)->SetNumberOfBins((unsigned int) b->value());
}

void guiMI::setNumberOfSamples_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiMI *) p)->SetNumberOfSamples((unsigned int) b->value());
} 

void guiMI::setNumberOfIterations_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiMI *) p)->SetNumberOfIterations((long int)b->value());
}

void guiMI::setRelaxFactor_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiMI *) p)->SetRelaxationFactor(b->value());
}

void guiMI::setMinStep_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiMI *) p)->SetMinStepLength(b->value());
}

void guiMI::setMaxStep_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiMI *) p)->SetMaxStepLength(b->value());
}

void guiMI::SetNumberOfBins(unsigned int bins) { } 
void guiMI::SetNumberOfSamples(unsigned int samples) { }
void guiMI::SetNumberOfIterations(long int number) { }
void guiMI::SetRelaxationFactor(double relax) { }
void guiMI::SetMinStepLength(double minStep) { }
void guiMI::SetMaxStepLength(double maxStep) { }
