//
// C++ Interface: guimi
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GUIMI_H
#define GUIMI_H

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Value_Input.H>
#include <FL/Fl_Output.H>

#include "miregistration.h"
/**
	@author 
*/
class guiMI{
public:
	guiMI();
	virtual ~guiMI();

    	Fl_Window *MIWindow;

	Fl_Button* close;

	Fl_Group* mainGroup;
	Fl_Group* paramGroup;

	Fl_Value_Input* numBins; 
	Fl_Value_Input* numSamples; 
	Fl_Value_Input* numIter; 
	Fl_Value_Input* relaxFactor;
	Fl_Value_Input* minStep; 
	Fl_Value_Input* maxStep; 
	
	enum TypePointSet {FIXED = 0, MOVING = 1};

	void Show();


private:
	
	static void setNumberOfBins_cb(Fl_Widget*, void*); 
	static void setNumberOfSamples_cb(Fl_Widget*, void*); 
	static void setNumberOfIterations_cb(Fl_Widget*, void*); 
	static void setRelaxFactor_cb(Fl_Widget*, void*); 
	static void setMinStep_cb(Fl_Widget*, void*); 
	static void setMaxStep_cb(Fl_Widget*, void*); 	

	static void register_cb(Fl_Widget*, void*); 
	static void close_cb(Fl_Widget *w, void *p);


public:
	virtual void SetNumberOfBins(unsigned int bins); 
	virtual void SetNumberOfSamples(unsigned int samples); 
	virtual void SetNumberOfIterations(long int number); 
	virtual void SetRelaxationFactor(double epsilon); 
	virtual void SetMinStepLength(double minStep); 
	virtual void SetMaxStepLength(double maxStep); 
	

};

#endif
