//
// C++ Implementation: guirigidreg
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "guirigidregistration.h"

guiRigidRegistration::guiRigidRegistration()
{
	int xDim = 230; 
	int yDim = 200; 

	RigidRegWindow = new Fl_Window(xDim, yDim, "Rigid Registration");
	// ICPWindow->box(FL_PLASTIC_UP_BOX);
	RigidRegWindow->resizable(); 
	RigidRegWindow->begin();

	mainGroup = new Fl_Group(0, 30, (xDim-10), (yDim-10)); 
	mainGroup->resizable();

	int inputX = xDim - 100;
	paramGroup = new Fl_Group(inputX, 15, 150, 130); 

	transScale = new Fl_Value_Input(inputX, 15, 60, 20, "Translation Scale:"); 
	transScale->labelsize(10); 

	rotScale = new Fl_Value_Input(inputX, 40, 60, 20, "Rotation Scale:"); 
	rotScale->labelsize(10);
	
	numIter = new Fl_Value_Input(inputX, 65, 60, 20, "Number Iterations:"); 
	numIter->labelsize(10); 

	epsFunc = new Fl_Value_Input(inputX, 90, 60, 20, "Epsilon Function:");
	epsFunc->labelsize(10);
	
	paramGroup->end();

	// actions
	close = new Fl_Button( xDim-75, yDim-30, 70, 20, "Ok");
	close->box(FL_PLASTIC_UP_BOX);
	close->down_box(FL_PLASTIC_DOWN_BOX); 
	close->labelsize(10); 
	
	mainGroup->end();
	RigidRegWindow->end();
	
	transScale->callback(setTranslationScale_cb, this);
	rotScale->callback(setRotationScale_cb, this);
	numIter->callback(setNumIterations_cb, this);  
	epsFunc->callback(setEpsilonFunc_cb, this); 

	close->callback(close_cb, this); 

}

guiRigidRegistration::~guiRigidRegistration()
{
}

void guiRigidRegistration::Show()
{
	RigidRegWindow->show();
}


void guiRigidRegistration::close_cb(Fl_Widget *w, void *p)
{
	((guiRigidRegistration *) p)->RigidRegWindow->hide(); 
}

void guiRigidRegistration::setTranslationScale_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiRigidRegistration *) p)->SetTranslationScale(b->value());
}

void guiRigidRegistration::setRotationScale_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiRigidRegistration *) p)->SetRotationScale(b->value());
} 

void guiRigidRegistration::setNumIterations_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiRigidRegistration *) p)->SetNumIterations((long int)b->value());
}

void guiRigidRegistration::setEpsilonFunc_cb(Fl_Widget *w, void *p)
{
	Fl_Value_Input* b = (Fl_Value_Input*)w;
	((guiRigidRegistration *) p)->SetEpsilonFunction(b->value());
}


void guiRigidRegistration::SetRotationScale(double scale) { } 
void guiRigidRegistration::SetTranslationScale(double scale) { }
void guiRigidRegistration::SetNumIterations(long int number) { }
void guiRigidRegistration::SetEpsilonFunction(double epsilon) { }

void guiRigidRegistration::Register() { }
//void guiRigidRegistration::GetRegTransform() { }
