//
// C++ Interface: icp
//
// Description: 
//
//
// Author:  <>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ICP_H
#define ICP_H

//  itk includes
#include "itkEuler3DTransform.h" 
#include "itkEuclideanDistancePointMetric.h" 
// #include "itkIterativeClosestPointMetric.h" 
#include "itkPointSetToPointSetMetric.h"
#include "itkLevenbergMarquardtOptimizer.h"
#include "itkPointSet.h" 
#include "itkPointSetToPointSetRegistrationMethod.h" 

//  c/c++ includes
#include <iostream> 
#include <fstream> 

class ICP {

public:

	typedef itk::PointSet < float, 3 > 	PointSetType; 
	// typedef PointSetType::PointType		PointType;
	// typedef PointSetType::PointsContainer	PointsContainer;

	PointSetType::Pointer my_fixedPointSet; 
	PointSetType::Pointer my_movingPointSet;

	// metric
	typedef itk::EuclideanDistancePointMetric < PointSetType, 
							PointSetType > MetricType; 
	typedef MetricType::TransformType		TransformBaseType; 
	typedef TransformBaseType::ParametersType	ParametersType; 
	typedef	TransformBaseType::JacobianType		JacobianType;
	
	MetricType::Pointer my_metric;

	// transform 
	typedef itk::Euler3DTransform < double > 	TransformType; 
	TransformType::Pointer my_transform; 

	// optimizer
	typedef itk::LevenbergMarquardtOptimizer	OptimizerType; 
	OptimizerType::Pointer my_optimizer; 

	// registration
	typedef itk::PointSetToPointSetRegistrationMethod < PointSetType, 
							PointSetType > RegistrationType;
	RegistrationType::Pointer my_registration;
	
	ICP(double, double, unsigned long, double, double, double, bool, bool);
	ICP(); 

	~ICP();

	void Register(); 

	void setEpsilonFunction(double theValue);
	double epsilonFunction() const;

	void setGradientTolerance(double theValue);
	double gradientTolerance() const;

	void setNumberOfIterations(unsigned long theValue);
	unsigned long numberOfIterations() const;

	void setRotationScale(double theValue);
	double rotationScale() const;

	void setTranslationScale(double theValue);
	double translationScale() const;

	void setUseCostFunctionGradient(bool theValue);
	bool useCostFunctionGradient() const;

	void setValueTolerance(double theValue);
	double valueTolerance() const;

	void setCalculateDistanceMap(bool theValue);
	bool calculateDistanceMap() const;
	
private: 

	bool 		my_useCostFunctionGradient;
	bool 		my_calculateDistanceMap;
	
	unsigned long 	my_numberOfIterations; 
	double 		my_gradientTolerance; 
	double		my_valueTolerance; 
	double		my_epsilonFunction; 
	
	double 		my_translationScale;
	double		my_rotationScale;

	void CalculateDistanceMap(); 
};

#endif
