//
// C++ Interface: landmarkregistrator
//
// Description: 
//
//
// Author:  <>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef LANDMARKREGISTRATOR_H
#define LANDMARKREGISTRATOR_H

#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImage.h"
#include "itkResampleImageFilter.h"
#include "itkLinearInterpolateImageFunction.h"
#include "itkEuclideanDistancePointMetric.h" 
#include "itkVersorRigid3DTransform.h"
#include "itkScaleSkewVersor3DTransform.h"
#include "itkLeastSquaredDistanceCostFunction.h"
#include "itkOnePlusOneEvolutionaryOptimizer.h"
#include "itkNormalVariateGenerator.h" 
#include "itkPointSetToPointSetRegistrationMethod.h" 
#include "itkObject.h"
#include "itkAffineTransform.h"
#include "itkMattesMutualInformationImageToImageMetric.h"
#include "itkImageRegistrationMethod.h"

/**
@author 
*/
class LandmarkRegistrator : public itk::Object
{

public:

    	LandmarkRegistrator();
    	~LandmarkRegistrator();

	// input
	typedef short PixelType;
	typedef itk::Image < PixelType, 3 > FixedImageType;
	typedef itk::Image < PixelType, 3 > MovingImageType; 	

	FixedImageType::Pointer my_fixedImage; 
	MovingImageType::Pointer my_movingImage;
	MovingImageType::Pointer my_initializedMovingImage;

	// interpolator 
	typedef itk::LinearInterpolateImageFunction <MovingImageType, double> InterpolatorType;
	InterpolatorType::Pointer my_interpolator; 
	
	// transform
	typedef itk::VersorRigid3DTransform < double > TransformType;
	TransformType::Pointer      my_transform;

	// metric
	typedef itk::LeastSquaredDistanceCostFunction < TransformType > LandmarkMetricType;
  	LandmarkMetricType::Pointer my_landmarkMetric;

	// registrator
	typedef itk::ImageRegistrationMethod<FixedImageType, MovingImageType> RegistrationType; 
	RegistrationType::Pointer my_registration; 

	typedef LandmarkMetricType::PointType		LandmarkType ;
    	typedef LandmarkMetricType::PointSetType	LandmarkSetType;
    	
	LandmarkSetType::Pointer    my_fixedLandmarkSet;
   	LandmarkSetType::Pointer    my_movingLandmarkSet; 
	
	// optimizer
	typedef itk::OnePlusOneEvolutionaryOptimizer OptimizerType;
	OptimizerType::Pointer	    my_landmarkOptimizer;

	typedef itk::Statistics::NormalVariateGenerator	GeneratorType;
	GeneratorType::Pointer	my_generator;

	LandmarkSetType::Pointer my_fixedPointSet; 
	LandmarkSetType::Pointer my_movingPointSet; 

    	typedef TransformType::ParametersType                 ParametersType;
   	typedef TransformType::ParametersType                 ScalesType;
	ParametersType              my_initialTransformParameters;
    	ScalesType                  my_optimizerScales;

	// resample filter
	typedef itk::ResampleImageFilter <MovingImageType, MovingImageType> ResampleFilterType; 
	ResampleFilterType::Pointer my_resampleFilter;

	// transform 
	typedef itk::AffineTransform <double, 3> AffineTransformType; 
	AffineTransformType::Pointer my_finalTransform; 

	itk::Point<double, 3> my_center;

	void SetEpsilonFunction(double theValue);
	double epsilonFunction() const;

	void SetNumberOfIterations(unsigned int theValue);
	unsigned long numberOfIterations() const;

	bool InitializeRegistration();

	
private: 
	unsigned long 	my_numberOfIterations; 
	double		my_epsilonFunction; 

};

#endif
