//
// C++ Interface: miregistration
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef MIREGISTRATION_H
#define MIREGISTRATION_H

#include "itkImageRegistrationMethod.h"
#include "itkAffineTransform.h"
#include "itkVersorRigid3DTransform.h"
#include "itkVersorRigid3DTransformOptimizer.h"
#include "itkMattesMutualInformationImageToImageMetric.h"
#include "itkMutualInformationImageToImageMetric.h"
#include "itkLinearInterpolateImageFunction.h" 
#include "itkRegularStepGradientDescentOptimizer.h"
#include "itkImage.h" 
#include "itkImageFileReader.h"
#include "itkQuaternionRigidTransform.h"
#include "itkQuaternionRigidTransformGradientDescentOptimizer.h"
#include "itkCenteredTransformInitializer.h"

#include "errorwindow.h"
/**
@author 
*/
class MIRegistration
{
  public:
	 MIRegistration();
	~MIRegistration();
  	
	// input
	typedef short PixelType;
	typedef itk::Image < PixelType, 3> FixedImageType;
	typedef itk::Image < PixelType, 3 > MovingImageType; 	

	FixedImageType::Pointer my_fixedImage; 
	MovingImageType::Pointer my_movingImage;

	//transform
  	typedef itk::VersorRigid3DTransform < double > TransformType;
    	TransformType::Pointer      my_transform;

	//optimizer
 	typedef itk::VersorRigid3DTransformOptimizer OptimizerType;
	OptimizerType::Pointer my_optimizer; 

	//interpolator 
	typedef itk::LinearInterpolateImageFunction <MovingImageType, double> InterpolatorType; 
	InterpolatorType::Pointer my_interpolator; 

	//registrator
	typedef itk::ImageRegistrationMethod<FixedImageType, MovingImageType> RegistrationType; 
	RegistrationType::Pointer my_registrator; 
	
	//metric 
	typedef itk::MattesMutualInformationImageToImageMetric <FixedImageType, MovingImageType> MetricType; 
	MetricType::Pointer my_metric;

 	typedef itk::CenteredTransformInitializer <TransformType, FixedImageType, MovingImageType> TransformInitializerType; 
	TransformInitializerType::Pointer my_initializer;
    	
	typedef RegistrationType::ParametersType  ParametersType;
   	typedef OptimizerType::ParametersType  ScalesType;
 	typedef TransformType::VersorType  VersorType;
  	typedef VersorType::VectorType     VectorType;
	
	ParametersType          my_initialTransformParameters;
    	ScalesType              my_optimizerScales; 
 	VersorType		my_rotation;
  	VectorType     		my_axis;

	bool Register(); 

	void SetNumberOfBins(unsigned int); 
	void SetNumberOfSamples(unsigned int); 
	void SetNumberOfIterations(unsigned int); 
	void SetMinStepLength(double); 
	void SetMaxStepLength(double); 
	void SetRelaxationFactor(double factor); 

	unsigned int numberOfBins(); 
	unsigned int numberOfSamples(); 
	unsigned int numberOfIterations();
	double minStep(); 
	double maxStep(); 
	double relaxationFactor(); 
	
private: 
	unsigned int my_numberOfBins; 
	unsigned int my_numberOfSamples; 	
	unsigned int my_numberOfIterations; 
	double my_minStepLength; 
	double my_maxStepLength; 
	double my_relaxationFactor; 

};

#endif
