//
// C++ Implementation: momentregistrator
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "momentregistrator.h"

MomentRegistrator::MomentRegistrator()
{
	my_fixedImage = 0; 
	my_movingImage = 0; 
	my_initializedMovingImage = 0; 

	my_momentsTransform = MomentsCalculatorType::AffineTransformType::New(); 
	my_momentsTransform->SetIdentity();
	
	my_transform = TransformType::New();
	my_transform->SetIdentity();

	my_optimizer = OptimizerType::New(); 
	my_interpolator = InterpolatorType::New(); 
	my_registration = RegistrationType::New(); 
	my_metric = MetricType::New(); 
	my_generator = GeneratorType::New();
	
	my_initializer = TransformInitializerType::New(); 

	my_initializer = TransformInitializerType::New(); 
	my_initialFinalTransform = AffineTransformType::New(); 
	my_finalTransform = AffineTransformType::New(); 
	my_resampleFilter = ResampleFilterType::New();

	my_optimizerScales.set_size(6);
	my_optimizerScales[0] = 200; // rotation
	my_optimizerScales[1] = 200;
	my_optimizerScales[2] = 200;
	my_optimizerScales[3] = 1;   // offset
	my_optimizerScales[4] = 1;
	my_optimizerScales[5] = 1;

	SetOptimizerNumberOfIterations(1000); 
	SetEpsilonFunction(1e-5); 
	SetNumberOfSamples(20000);
	
}

MomentRegistrator::~MomentRegistrator()
{
}

bool MomentRegistrator::initializeRegistration()
{
	bool successful = false; 

	// set up transform
	MomentsCalculatorType::Pointer momentCalculator;
	momentCalculator = MomentsCalculatorType::New(); 

	// compute moments for fixed image 
	momentCalculator->SetImage(my_fixedImage); 
	momentCalculator->Compute(); 
	
	MomentsCalculatorType::AffineTransformType::Pointer fixedImageAxesTransform; 
	fixedImageAxesTransform = momentCalculator->GetPhysicalAxesToPrincipalAxesTransform(); 
	
	TransformType::InputPointType fixedImageCenterOfMass; 
	for(int i=0; i<3; i++) 
	{
		fixedImageCenterOfMass[i] = momentCalculator->GetCenterOfGravity()[i];
	}

	// compute moments for moving image
	momentCalculator->SetImage(my_movingImage); 
	momentCalculator->Compute();
	
	MomentsCalculatorType::AffineTransformType::Pointer movingImageAxesTransform; 
	movingImageAxesTransform = momentCalculator->GetPrincipalAxesToPhysicalAxesTransform(); 
	
	TransformType::InputPointType movingImageCenterOfMass; 
	for(int i=0; i<3; i++) 
	{
		movingImageCenterOfMass[i] = momentCalculator->GetCenterOfGravity()[i];
	}

	my_momentsTransform->SetCenter(movingImageCenterOfMass); 
	my_momentsTransform->SetMatrix(movingImageAxesTransform->GetMatrix());
	my_momentsTransform->SetOffset(movingImageAxesTransform->GetOffset());
	my_momentsTransform->Compose(fixedImageAxesTransform, true); 

	my_finalTransform = my_momentsTransform; 
 			
	successful = true; 	
	return (successful);
	std::cout << "DEBUG: Moment: FINAL affine transform: " << std::endl
            << my_momentsTransform->GetParameters() << std::endl
            << "   Offset = " << my_momentsTransform->GetOffset() << std::endl
            << "   Center = " << my_momentsTransform->GetCenter() << std::endl;
}

bool MomentRegistrator::Register()
{
	bool success = false; 
	success = initializeRegistration(); 
	
	if(success == false)
		return (false); 

	
	// ITK transforms the fixed image into the moving image
	my_registration->SetMovingImage(my_fixedImage) ;     my_registration->SetFixedImage( my_movingImage);  
	
	my_registration->SetFixedImageRegion(my_movingImage->GetBufferedRegion());

	my_registration->SetMetric(my_metric); 
	my_registration->SetOptimizer(my_optimizer); 
	my_registration->SetInterpolator(my_interpolator); 
	my_registration->SetTransform(my_transform); 

	my_transform->SetCenter(my_momentsTransform->GetCenter()); 
	my_transform->SetMatrix(my_momentsTransform->GetMatrix());
	my_transform->SetOffset(my_momentsTransform->GetOffset());
  	
  	my_registration->SetInitialTransformParameters(my_transform->GetParameters());
	
	my_interpolator->SetInputImage(my_fixedImage); 
	my_metric->SetNumberOfSpatialSamples(my_numberOfSamples); 

	// set up optimizer 
	my_optimizer->SetNormalVariateGenerator(GeneratorType::New());
      	my_optimizer->SetMaximumIteration(my_optimizerNumberOfIterations);
        my_optimizer->SetEpsilon(my_epsilonFunction);
        my_optimizer->Initialize(1.01); // Initial search radius
      	my_optimizer->SetScales( my_optimizerScales );

	try
	{
		my_registration->StartRegistration(); 
	}
	catch( itk::ExceptionObject &e )
	{
		e.Print (std::cout);
		ErrorWindow *error = new ErrorWindow((char*)e.GetDescription ());
		error->Show();
		return(false);
	}
	catch( ... )
	{
		char *errorString = "Unknown exception caught in LandmarkRegistrator:";
		ErrorWindow *error = new ErrorWindow(errorString);
		error->Show(); 
		return(false);
	}
  	
 	my_finalTransform->SetIdentity();
  	my_finalTransform->SetCenter(my_transform->GetCenter());
  	my_finalTransform->SetMatrix(my_transform->GetRotationMatrix());
  	my_finalTransform->SetOffset(my_transform->GetOffset());
  
 	std::cout << "DEBUG: Rigid: FINAL affine transform: "  << std::endl
            << my_finalTransform->GetParameters() << std::endl
            << "   Offset = " << my_finalTransform->GetOffset() << std::endl
            << "   Center = " << my_finalTransform->GetCenter() << std::endl;


	return(true);
}


void MomentRegistrator::SetNumberOfIterations(unsigned int iters)
{
	my_numberOfIterations = iters;
}

void MomentRegistrator::SetOptimizerNumberOfIterations(unsigned int iters)
{
	my_optimizerNumberOfIterations = iters;
}

void MomentRegistrator::SetNumberOfSamples(unsigned int samples)
{
	my_numberOfSamples = samples;
}

void MomentRegistrator::SetEpsilonFunction(double epsilon)
{
	my_epsilonFunction = epsilon; 
} 

unsigned int MomentRegistrator::numberOfIterations()
{
	return my_numberOfIterations; 
}

double MomentRegistrator::epsilonFunctions()
{
	return my_epsilonFunction;
}

unsigned int MomentRegistrator::numberOfSamples()
{
	return my_numberOfSamples;
}
