//
// C++ Interface: momentregistrator
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef MOMENTREGISTRATOR_H
#define MOMENTREGISTRATOR_H

#include "itkImageRegistrationMethod.h"
#include "itkAffineTransform.h"
#include "itkImageMomentsCalculator.h"
#include "itkImage.h" 
#include "itkOnePlusOneEvolutionaryOptimizer.h"
#include "itkNormalVariateGenerator.h"
#include "itkStatisticsImageFilter.h"
#include "itkVersorRigid3DTransform.h"
#include "itkMattesMutualInformationImageToImageMetric.h"
#include "itkLinearInterpolateImageFunction.h"
#include "itkRegularStepGradientDescentOptimizer.h"
#include "itkResampleImageFilter.h"
#include "itkCenteredTransformInitializer.h"
#include "itkRigid3DTransform.h"
#include "itkImageFileWriter.h"

#include "errorwindow.h"

/**
	@author 
*/
class MomentRegistrator{
public:
    	MomentRegistrator();
    	~MomentRegistrator();

	// input

	typedef short PixelType;
	typedef itk::Image < PixelType, 3 > FixedImageType;
	typedef itk::Image < PixelType, 3 > MovingImageType;

	FixedImageType::Pointer my_fixedImage; 
	MovingImageType::Pointer my_movingImage;
	MovingImageType::Pointer my_initializedMovingImage;

	// transform for optimizer
	typedef itk::ImageMomentsCalculator <FixedImageType> MomentsCalculatorType;
	MomentsCalculatorType::AffineTransformType::Pointer my_momentsTransform;

	// transform 
	typedef itk::VersorRigid3DTransform<double>      TransformType ;
	TransformType::Pointer my_transform; 

	// generator
	typedef itk::Statistics::NormalVariateGenerator	GeneratorType;
	GeneratorType::Pointer	my_generator;
	
	// optimizer
	typedef itk::OnePlusOneEvolutionaryOptimizer OptimizerType;
	OptimizerType::Pointer  my_optimizer;
  
	typedef itk::CenteredTransformInitializer <TransformType, FixedImageType, MovingImageType> TransformInitializerType; 
	TransformInitializerType::Pointer my_initializer;

	// metric 
	 typedef itk::MattesMutualInformationImageToImageMetric< FixedImageType, MovingImageType > MetricType;
	 MetricType::Pointer my_metric;

	// interpolator 
	typedef itk::LinearInterpolateImageFunction <MovingImageType, double> InterpolatorType;
	InterpolatorType::Pointer my_interpolator; 

	// registrator
	typedef itk::ImageRegistrationMethod<FixedImageType, MovingImageType> RegistrationType; 
	RegistrationType::Pointer my_registration; 

	// final transform and resampling stuff
	typedef itk::AffineTransform <double, 3> AffineTransformType; 
	AffineTransformType::Pointer my_initialFinalTransform; 
	AffineTransformType::Pointer my_finalTransform; 

	typedef itk::ResampleImageFilter <MovingImageType, MovingImageType> ResampleFilterType; 
	ResampleFilterType::Pointer my_resampleFilter;

   	typedef TransformType::ParametersType       	ParametersType ;
    	typedef TransformType::ParametersType       	ScalesType ;
	typedef TransformType::VersorType  VersorType;
  	typedef VersorType::VectorType     VectorType;
	
	ParametersType          my_initialTransformParameters;
    	ScalesType              my_optimizerScales; 
 	VersorType		my_rotation;
  	VectorType     		my_axis;
	
	bool initializeRegistration();
	bool Register(); 

	void SetNumberOfIterations(unsigned int iters); 
	void SetOptimizerNumberOfIterations(unsigned int iters); 
	void SetEpsilonFunction(double epsilon); 
	void SetNumberOfSamples(unsigned int samples); 

	unsigned int numberOfIterations(); 
	double epsilonFunctions();
	unsigned int numberOfSamples(); 
	
private: 
	unsigned int my_numberOfIterations; 
	unsigned int my_optimizerNumberOfIterations;
	unsigned int my_numberOfSamples;
	double my_epsilonFunction;
	
};

#endif
